/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.DefaultHighlighterDark;

import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.ui.text.StyleConstantsEx;
import com.github.weisj.darklaf.util.Alignment;
import com.github.weisj.darklaf.util.ColorWrapper;
import com.github.weisj.darklaf.util.graphics.GraphicsContext;
import com.github.weisj.darklaf.util.graphics.GraphicsUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.Objects;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;

public class DarkHighlightPainter
extends DefaultHighlighter.DefaultHighlightPainter {
    private Paint paint;
    private Color color;
    private final HighlighterColor wrapper;
    private boolean roundedEdges;
    private boolean extendLines;
    private AlphaComposite alphaComposite;
    private float alpha;
    private final int arcSize;
    private boolean enabled;
    private int repaintCount;
    private int lastSelStart = -1;
    private int lastSelEnd = -1;
    private final Shape[] arcs = new Shape[4];
    private final Point tmpPoint = new Point();

    public DarkHighlightPainter() {
        this((Paint)null);
    }

    public DarkHighlightPainter(Paint paint) {
        this(paint, false);
    }

    public DarkHighlightPainter(Paint paint, boolean rounded) {
        this(paint, rounded, 1.0f);
    }

    public DarkHighlightPainter(Paint paint, boolean rounded, float alpha) {
        super(null);
        this.wrapper = new HighlighterColor(null);
        this.arcSize = UIManager.getInt("Highlight.arc");
        this.setPaint(paint);
        this.setRoundedEdges(rounded);
        this.setAlpha(alpha);
        this.setEnabled(true);
    }

    public boolean getRoundedEdges() {
        return this.roundedEdges;
    }

    public void setRoundedEdges(boolean rounded) {
        this.roundedEdges = rounded;
    }

    @Override
    public Color getColor() {
        return this.wrapper;
    }

    @Override
    public void paint(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c) {
        if (!this.enabled) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        GraphicsContext context = new GraphicsContext((Graphics)g2d);
        this.color = c.getSelectedTextColor();
        this.wrapper.setColor(this.color);
        this.wrapper.setCustomForeground(!Objects.equals(this.color, c.getForeground()));
        if (this.getAlpha() < 1.0f) {
            g2d.setComposite(this.getAlphaComposite());
        }
        super.paint(g, offs0, offs1, bounds, c);
        context.restore();
    }

    public float getAlpha() {
        return this.alpha;
    }

    private AlphaComposite getAlphaComposite() {
        if (this.alphaComposite == null) {
            this.alphaComposite = AlphaComposite.getInstance(3, this.alpha);
        }
        return this.alphaComposite;
    }

    public Paint getPaint(Component c, Shape bounds) {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
        this.alpha = Math.max(alpha, 0.0f);
        this.alpha = Math.min(1.0f, alpha);
        this.alphaComposite = null;
    }

    @Override
    public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, View view) {
        Shape dirtyShape;
        boolean lineExtension;
        boolean customColor;
        if (!this.enabled) {
            return bounds;
        }
        this.color = (Color)view.getAttributes().getAttribute(StyleConstantsEx.SelectedForeground);
        if (this.color == null) {
            this.color = StyleConstants.getForeground(view.getAttributes());
        }
        boolean bl = customColor = this.color != null;
        if (this.color == null) {
            this.color = c.getSelectedTextColor();
        }
        boolean isForeground = Objects.equals(this.color, c.getForeground());
        customColor = customColor || isForeground;
        this.wrapper.setColor(this.color);
        this.wrapper.setCustomForeground(!isForeground);
        Graphics2D g2d = (Graphics2D)g;
        GraphicsContext context = GraphicsUtil.setupStrokePainting((Graphics)g2d);
        if (this.getAlpha() < 1.0f) {
            g2d.setComposite(this.getAlphaComposite());
        }
        this.setupColor((Graphics2D)g, c, bounds);
        boolean ltr = this.isLeftTorRight(c);
        boolean rounded = ltr && this.isRounded();
        boolean bl2 = lineExtension = ltr && this.isLineExtendingEnabled();
        if (lineExtension || rounded) {
            dirtyShape = this.paintRoundedLayer(g2d, c, offs0, offs1, context, rounded, lineExtension, false);
            if (lineExtension) {
                if (this.lastSelEnd != c.getSelectionEnd() || this.lastSelStart != c.getSelectionStart()) {
                    this.lastSelEnd = c.getSelectionEnd();
                    this.lastSelStart = c.getSelectionStart();
                    this.repaintCount = 1;
                }
                if (this.repaintCount > 0) {
                    if (customColor) {
                        c.repaint();
                    } else {
                        Rectangle repaintBounds = dirtyShape.getBounds();
                        repaintBounds.grow(10, 10);
                        c.repaint(repaintBounds);
                    }
                    --this.repaintCount;
                }
            }
        } else {
            Color oldColor = this.wrapper.getColor();
            this.wrapper.setColor(g.getColor());
            dirtyShape = super.paintLayer(g, offs0, offs1, bounds, c, view);
            this.wrapper.setColor(oldColor);
        }
        context.restore();
        return dirtyShape;
    }

    private boolean isLeftTorRight(JTextComponent c) {
        return !TextAttribute.RUN_DIRECTION_RTL.equals(c.getDocument().getProperty(TextAttribute.RUN_DIRECTION)) && !Boolean.TRUE.equals(c.getDocument().getProperty("i18n"));
    }

    protected Rectangle paintRoundedLayer(Graphics2D g, JTextComponent c, int offs0, int offs1, GraphicsContext context, boolean rounded, boolean extendLines, boolean isPaintingPreceding) {
        int selectionStart = c.getSelectionStart();
        int selectionEnd = c.getSelectionEnd();
        Insets ins = c.getInsets();
        Rectangle posOffs0 = this.getPosRect(c, offs0);
        Rectangle posOffs1 = this.getPosRect(c, offs1, Position.Bias.Backward);
        Rectangle posStart = this.getPosRect(c, selectionStart);
        Rectangle posEnd = this.getPosRect(c, selectionEnd);
        int currentLineStart = isPaintingPreceding ? offs0 : this.getOffset(c, 0, posOffs0.y);
        int currentLineEnd = isPaintingPreceding ? offs1 : this.getOffset(c, c.getWidth(), posOffs1.y);
        int previousLineEnd = currentLineStart - 1;
        Rectangle prevEnd = this.getPosRect(c, previousLineEnd);
        int previousLineStart = this.getOffset(c, 0, prevEnd.y);
        Rectangle prevStart = this.getPosRect(c, previousLineStart);
        int nextLineStart = currentLineEnd + 1;
        int nextLineEnd = this.getOffset(c, c.getWidth(), this.getPosRect((JTextComponent)c, (int)nextLineStart).y);
        if (nextLineEnd < nextLineStart) {
            nextLineEnd = nextLineStart;
        }
        boolean isEndOfLine = offs1 >= c.getDocument().getLength() - 1 || this.getPosRect((JTextComponent)c, (int)(offs1 + 1)).y > posOffs1.y;
        boolean isStartOfLine = offs0 == 0 || this.getPosRect((JTextComponent)c, (int)(offs0 - 1)).y < posOffs0.y;
        Rectangle layerRect = this.getRect(posOffs0, posOffs1);
        Rectangle previousLineRect = this.getRect(prevStart, prevEnd);
        Rectangle currentLineRect = this.getLineRect(c, currentLineStart, currentLineEnd);
        Rectangle nextLineRect = this.getLineRect(c, nextLineStart, nextLineEnd);
        if (posStart.y == previousLineRect.y) {
            previousLineRect = this.getRect(posStart, this.getPosRect(c, previousLineEnd, Position.Bias.Backward));
        }
        if (posEnd.y == nextLineRect.y) {
            nextLineRect = this.getRect(this.getPosRect(c, nextLineStart), posEnd);
        }
        if (posStart.y == currentLineRect.y) {
            currentLineRect.width = currentLineRect.x + currentLineRect.width - posStart.x;
            currentLineRect.x = posStart.x;
        }
        if (posEnd.y == currentLineRect.y) {
            currentLineRect.width = posEnd.x + posEnd.width - currentLineRect.x;
        }
        boolean hasLineAbove = previousLineEnd >= selectionStart;
        boolean hasLineBelow = nextLineStart <= selectionEnd;
        boolean previousLineVisible = hasLineAbove && previousLineRect.width > 0 && previousLineStart < previousLineEnd;
        boolean nextLineVisible = hasLineBelow && nextLineRect.width > 0 && nextLineStart < nextLineEnd;
        boolean paintPreviousLine = false;
        if (extendLines) {
            this.extendLine(c, ins, previousLineRect, hasLineAbove && previousLineStart >= selectionStart, hasLineAbove && previousLineEnd <= selectionEnd);
            boolean extendNextRight = hasLineBelow && nextLineEnd < c.getDocument().getLength() && this.getOffset(c, this.getPosRect(c, nextLineEnd + 1)) <= selectionEnd;
            this.extendLine(c, ins, nextLineRect, hasLineBelow && nextLineStart >= selectionStart, extendNextRight);
            paintPreviousLine = hasLineAbove && (previousLineStart == previousLineEnd || previousLineEnd == selectionStart);
            previousLineVisible = hasLineAbove;
            if (nextLineRect.y != posEnd.y) {
                nextLineVisible = hasLineBelow;
            }
            boolean extendRight = isPaintingPreceding || hasLineBelow && this.endX(layerRect) == this.endX(currentLineRect);
            boolean extendLeft = isPaintingPreceding || hasLineAbove && this.startX(layerRect) == this.startX(currentLineRect);
            this.extendLine(c, ins, layerRect, extendLeft &= offs0 > selectionStart, extendRight &= offs1 < selectionEnd);
            this.extendLine(c, ins, currentLineRect, extendLeft, extendRight);
            if (isPaintingPreceding) {
                layerRect.height = currentLineRect.height;
            }
        }
        boolean canRoundLeft = rounded && (isStartOfLine || this.startX(currentLineRect) == this.startX(layerRect));
        boolean canRoundRight = rounded && (isEndOfLine || this.endX(currentLineRect) == this.endX(layerRect));
        boolean roundedTopLeft = !previousLineVisible || this.leftRoundedVisible(currentLineRect, previousLineRect);
        boolean roundedTopRight = !previousLineVisible || this.rightRoundedVisible(currentLineRect, previousLineRect);
        boolean roundedBottomLeft = !nextLineVisible || this.leftRoundedVisible(currentLineRect, nextLineRect);
        boolean roundedBottomRight = !nextLineVisible || this.rightRoundedVisible(currentLineRect, nextLineRect);
        boolean arcTopLeft = previousLineVisible && !roundedTopLeft && this.leftArcVisible(currentLineRect, previousLineRect);
        boolean arcTopRight = previousLineVisible && !roundedTopRight && this.rightArcVisible(currentLineRect, previousLineRect);
        boolean arcBottomLeft = nextLineVisible && !roundedBottomLeft && this.leftArcVisible(currentLineRect, nextLineRect);
        boolean arcBottomRight = nextLineVisible && !roundedBottomRight && this.rightArcVisible(currentLineRect, nextLineRect);
        layerRect = this.paintRoundRect(g, context, layerRect, canRoundLeft && roundedTopLeft, canRoundRight && roundedTopRight, canRoundLeft && roundedBottomLeft, canRoundRight && roundedBottomRight);
        Rectangle r = this.paintArcs(g, context, layerRect, canRoundLeft && arcTopLeft, canRoundRight && arcTopRight, canRoundLeft && arcBottomLeft, canRoundRight && arcBottomRight);
        if (paintPreviousLine && !isPaintingPreceding) {
            Rectangle prev = this.paintRoundedLayer(g, c, Math.max(previousLineStart, selectionStart), Math.min(previousLineEnd, selectionEnd), context, rounded, extendLines, true);
            this.convexHull(r, prev);
        }
        return r;
    }

    private void extendLine(JTextComponent c, Insets ins, Rectangle rect, boolean extendLeft, boolean extendRight) {
        if (extendRight || extendLeft) {
            int x = this.startX(rect);
            if (extendRight) {
                rect.width = c.getWidth() - ins.left - x;
            }
            if (extendLeft) {
                rect.width = rect.x + rect.width - ins.left;
                rect.x = ins.left;
            }
        }
    }

    public boolean isLineExtendingEnabled() {
        return this.extendLines;
    }

    public void setLineExtendingEnabled(boolean enabled) {
        this.extendLines = enabled;
    }

    private boolean leftRoundedVisible(Rectangle current, Rectangle other) {
        return this.startX(other) > this.startX(current) + this.arcSize || this.endX(other) < this.startX(current);
    }

    private boolean rightRoundedVisible(Rectangle current, Rectangle other) {
        return this.endX(other) < this.endX(current) - this.arcSize || this.startX(other) > this.endX(current);
    }

    private boolean leftArcVisible(Rectangle current, Rectangle other) {
        return this.startX(other) <= this.startX(current) - this.arcSize && this.endX(other) >= this.startX(current);
    }

    private boolean rightArcVisible(Rectangle current, Rectangle other) {
        return this.endX(other) >= this.endX(current) + this.arcSize && this.startX(other) <= this.endX(current);
    }

    private Rectangle getPosRect(JTextComponent c, int offset) {
        return this.getPosRect(c, offset, Position.Bias.Forward);
    }

    private Rectangle getPosRect(JTextComponent c, int offset, Position.Bias bias) {
        try {
            return c.getUI().modelToView(c, Math.max(0, Math.min(offset, c.getDocument().getLength())), bias);
        }
        catch (BadLocationException badLocationException) {
        }
        catch (IllegalArgumentException e) {
            new RuntimeException("" + offset).printStackTrace();
        }
        return new Rectangle(-2147483548, -2147483548, 0, 0);
    }

    private int getOffset(JTextComponent c, int x, int y) {
        this.tmpPoint.setLocation(x, y);
        return this.getOffset(c, this.tmpPoint);
    }

    private int getOffset(JTextComponent c, Rectangle r) {
        return this.getOffset(c, r.getLocation());
    }

    private int getOffset(JTextComponent c, Point p) {
        return c.viewToModel(p);
    }

    private int startX(Rectangle r) {
        return r.x;
    }

    private int endX(Rectangle r) {
        return r.x + r.width;
    }

    private int startY(Rectangle r) {
        return r.y;
    }

    private int endY(Rectangle r) {
        return r.y + r.height;
    }

    private Rectangle getLineRect(JTextComponent c, int startPos, int endPos) {
        Rectangle rectStart = this.getPosRect(c, startPos);
        Rectangle rectEnd = endPos <= startPos ? rectStart : this.getPosRect(c, endPos, Position.Bias.Backward);
        return this.getRect(rectStart, rectEnd);
    }

    private Rectangle getRect(Rectangle start, Rectangle end) {
        return new Rectangle(start.x, start.y, end.x + end.width - start.x, end.y + end.height - start.y);
    }

    private void convexHull(Rectangle start, Rectangle end) {
        int startX = Math.min(this.startX(start), this.startX(end));
        int startY = Math.min(this.startY(start), this.startY(end));
        int endX = Math.max(this.endX(start), this.endX(end));
        int endY = Math.max(this.endY(start), this.endY(end));
        start.setRect(startX, startY, endX - startX, endY - startY);
    }

    private boolean isRounded() {
        return this.roundedEdges;
    }

    private Rectangle paintRoundRect(Graphics g, GraphicsContext context, Rectangle shape, boolean topLeft, boolean topRight, boolean bottomLeft, boolean bottomRight) {
        boolean showBottom;
        Rectangle r = new Rectangle(shape);
        int aw = Math.min(this.arcSize, r.width);
        int ah = Math.min(this.arcSize, r.height);
        g.clipRect(r.x, r.y, r.width, r.height);
        boolean showLeft = topLeft || bottomLeft;
        boolean showRight = topRight || bottomRight;
        boolean showTop = topRight || topLeft;
        boolean bl = showBottom = bottomLeft || bottomRight;
        if (!showLeft) {
            r.x -= aw;
            r.width += aw;
        }
        if (!showRight) {
            r.width += aw;
        }
        if (!showBottom) {
            r.height += ah;
        }
        if (!showTop) {
            r.y -= ah;
            r.height += ah;
        }
        if (!(topLeft || topRight || bottomRight || bottomLeft)) {
            PaintUtil.fillRect(g, r);
        } else {
            g.fillRoundRect(r.x, r.y, r.width, r.height, aw, ah);
            if (!topLeft) {
                g.fillRect(r.x, r.y, aw, ah);
            }
            if (!topRight) {
                g.fillRect(r.x + r.width - aw, r.y, aw, ah);
            }
            if (!bottomLeft) {
                g.fillRect(r.x, r.y + r.height - ah, aw, ah);
            }
            if (!bottomRight) {
                g.fillRect(r.x + r.width - aw, r.y + r.height - ah, aw, ah);
            }
        }
        context.restoreClip();
        return shape;
    }

    private Rectangle paintArcs(Graphics2D g, GraphicsContext context, Rectangle r, boolean topLeft, boolean topRight, boolean bottomLeft, boolean bottomRight) {
        if (r.isEmpty()) {
            return r;
        }
        Rectangle alloc = new Rectangle(r);
        if (topLeft || bottomLeft) {
            alloc.x -= this.arcSize;
            alloc.width += this.arcSize;
        }
        if (topRight || bottomRight) {
            alloc.width += this.arcSize;
        }
        if (topLeft) {
            g.translate(r.x - this.arcSize, r.y);
            g.fill(this.getArc(Alignment.NORTH_WEST));
            context.restoreTransform();
        }
        if (topRight) {
            g.translate(r.x + r.width, r.y);
            g.fill(this.getArc(Alignment.NORTH_EAST));
            context.restoreTransform();
        }
        if (bottomLeft) {
            g.translate(r.x - this.arcSize, r.y + r.height - this.arcSize);
            g.fill(this.getArc(Alignment.SOUTH_WEST));
            context.restoreTransform();
        }
        if (bottomRight) {
            g.translate(r.x + r.width, r.y + r.height - this.arcSize);
            g.fill(this.getArc(Alignment.SOUTH_EAST));
            context.restoreTransform();
        }
        return alloc;
    }

    private void setupColor(Graphics2D g2d, JTextComponent c, Shape bounds) {
        Paint paint = this.getPaint(c, bounds);
        if (paint == null) {
            g2d.setColor(c.getSelectionColor());
        } else {
            g2d.setPaint(paint);
        }
    }

    private Shape getArc(Alignment a) {
        Shape arc = this.arcs[this.getIndex(a)];
        if (arc == null) {
            Area arcArea = new Area(new Rectangle2D.Double(0.0, 0.0, this.arcSize, this.arcSize));
            arcArea.subtract(new Area(this.getSubtractShape(a)));
            this.arcs[this.getIndex((Alignment)a)] = arc = arcArea;
        }
        return arc;
    }

    private Shape getSubtractShape(Alignment a) {
        switch (a) {
            case NORTH_EAST: {
                return new Arc2D.Double(0.0, 0.0, 2 * this.arcSize, 2 * this.arcSize, 90.0, 90.0, 2);
            }
            case NORTH_WEST: {
                return new Arc2D.Double(-this.arcSize, 0.0, 2 * this.arcSize, 2 * this.arcSize, 0.0, 90.0, 2);
            }
            case SOUTH_EAST: {
                return new Arc2D.Double(0.0, -this.arcSize, 2 * this.arcSize, 2 * this.arcSize, 180.0, 90.0, 2);
            }
            case SOUTH_WEST: {
                return new Arc2D.Double(-this.arcSize, -this.arcSize, 2 * this.arcSize, 2 * this.arcSize, 270.0, 90.0, 2);
            }
        }
        return new Rectangle();
    }

    private int getIndex(Alignment a) {
        switch (a) {
            case NORTH_EAST: {
                return 0;
            }
            case NORTH_WEST: {
                return 1;
            }
            case SOUTH_EAST: {
                return 2;
            }
            case SOUTH_WEST: {
                return 3;
            }
        }
        return 0;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.wrapper.setEnabled(enabled);
        this.enabled = enabled;
    }

    private static class HighlighterColor
    extends ColorWrapper {
        private boolean enabled;
        private boolean customForeground;

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setCustomForeground(boolean customForeground) {
            this.customForeground = customForeground;
        }

        public HighlighterColor(Color color) {
            super(color);
        }

        public boolean equals(Object obj) {
            return obj != null && this.enabled && !this.customForeground;
        }
    }
}

