/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action.impl;

import java.text.DecimalFormat;
import org.apache.jmeter.control.TransactionController;
import org.apache.jmeter.gui.action.TreeNodeNamingPolicy;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class DefaultTreeNodeNamingPolicy
implements TreeNodeNamingPolicy {
    public static final char TRANSACTION_CHILDREN_SEPARATOR = '-';
    private static final String PREFIX = JMeterUtils.getPropDefault("naming_policy.prefix", "");
    private static final String SUFFIX = JMeterUtils.getPropDefault("naming_policy.suffix", "");
    private int index;
    private DecimalFormat formatter;

    @Override
    public void rename(JMeterTreeNode parentNode, JMeterTreeNode childNode, int iterationIndex) {
        if (childNode.getUserObject() instanceof TransactionController || childNode.getUserObject() instanceof Sampler) {
            childNode.setName(parentNode.getName() + '-' + this.formatter.format(this.index));
            ++this.index;
        }
    }

    @Override
    public void resetState(JMeterTreeNode rootNode) {
        int numberOfChildren = rootNode.getChildCount();
        this.index = 0;
        int numberOfDigits = String.valueOf(numberOfChildren).length();
        StringBuilder formatSB = new StringBuilder(numberOfDigits);
        for (int i = 0; i < numberOfDigits; ++i) {
            formatSB.append("0");
        }
        this.formatter = new DecimalFormat(formatSB.toString());
    }

    @Override
    public void nameOnCreation(JMeterTreeNode node) {
        if (node.getName().isEmpty()) {
            node.setName(((TestElement)node.getUserObject()).getClass().getSimpleName());
        }
        node.setName(PREFIX + node.getName() + SUFFIX);
    }
}

