/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.layout;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import org.apache.log4j.LogManager;

public class DefaultLayoutFactory {
    private static volatile String defaultPatternLayout = null;

    private DefaultLayoutFactory() {
    }

    public static String getDefaultPatternLayout() {
        return DefaultLayoutFactory.getPatternLayout("org/apache/log4j/chainsaw/layout/DefaultDetailLayout.html");
    }

    public static String getFullPatternLayout() {
        return DefaultLayoutFactory.getPatternLayout("org/apache/log4j/chainsaw/layout/FullDetailLayout.html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPatternLayout(String fileNamePath) {
        StringBuffer content = new StringBuffer();
        URL defaultLayoutURL = DefaultLayoutFactory.class.getClassLoader().getResource(fileNamePath);
        if (defaultLayoutURL == null) {
            LogManager.getLogger(DefaultLayoutFactory.class).warn("Could not locate the default Layout for Event Details and Tooltips");
        } else {
            int endIndex;
            try (BufferedReader reader = null;){
                String line;
                reader = new BufferedReader(new InputStreamReader(defaultLayoutURL.openStream()));
                while ((line = reader.readLine()) != null) {
                    content.append(line).append("\n");
                }
            }
            catch (Exception e) {
                content = new StringBuffer("%r [%t] %p %c %x - %m%n");
            }
            String trimmedContent = content.toString().trim();
            String startComment = "<!--";
            String endComment = "-->";
            if (trimmedContent.startsWith(startComment) && (endIndex = trimmedContent.indexOf(endComment)) > -1) {
                trimmedContent = trimmedContent.substring(endIndex + endComment.length()).trim();
            }
            defaultPatternLayout = trimmedContent;
        }
        return defaultPatternLayout;
    }
}

