/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.plugins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.plugins.Plugin;
import org.apache.log4j.plugins.PluginEvent;
import org.apache.log4j.plugins.PluginListener;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggerRepositoryEventListener;
import org.apache.log4j.spi.LoggerRepositoryEx;

public final class PluginRegistry {
    private final Map<String, Plugin> pluginMap;
    private final LoggerRepositoryEx loggerRepository;
    private final RepositoryListener listener = new RepositoryListener();
    private final List listenerList = Collections.synchronizedList(new ArrayList());

    public PluginRegistry(LoggerRepositoryEx repository) {
        this.pluginMap = new HashMap<String, Plugin>();
        this.loggerRepository = repository;
        this.loggerRepository.addLoggerRepositoryEventListener(this.listener);
    }

    public LoggerRepositoryEx getLoggerRepository() {
        return this.loggerRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pluginNameExists(String name) {
        Map<String, Plugin> map = this.pluginMap;
        synchronized (map) {
            return this.pluginMap.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlugin(Plugin plugin) {
        Map<String, Plugin> map = this.pluginMap;
        synchronized (map) {
            String name = plugin.getName();
            plugin.setLoggerRepository(this.getLoggerRepository());
            Plugin existingPlugin = this.pluginMap.get(name);
            if (existingPlugin != null) {
                existingPlugin.shutdown();
            }
            this.pluginMap.put(name, plugin);
            this.firePluginStarted(plugin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePluginStarted(Plugin plugin) {
        PluginEvent e = null;
        List list = this.listenerList;
        synchronized (list) {
            for (Object aListenerList : this.listenerList) {
                PluginListener l = (PluginListener)aListenerList;
                if (e == null) {
                    e = new PluginEvent(plugin);
                }
                l.pluginStarted(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePluginStopped(Plugin plugin) {
        PluginEvent e = null;
        List list = this.listenerList;
        synchronized (list) {
            for (Object aListenerList : this.listenerList) {
                PluginListener l = (PluginListener)aListenerList;
                if (e == null) {
                    e = new PluginEvent(plugin);
                }
                l.pluginStopped(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Plugin> getPlugins() {
        Map<String, Plugin> map = this.pluginMap;
        synchronized (map) {
            ArrayList<Plugin> pluginList = new ArrayList<Plugin>(this.pluginMap.size());
            pluginList.addAll(this.pluginMap.values());
            return pluginList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPlugins(Class pluginClass) {
        Map<String, Plugin> map = this.pluginMap;
        synchronized (map) {
            ArrayList<Plugin> pluginList = new ArrayList<Plugin>(this.pluginMap.size());
            for (Plugin plugin : this.pluginMap.values()) {
                if (!pluginClass.isInstance(plugin)) continue;
                pluginList.add(plugin);
            }
            return pluginList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plugin stopPlugin(String pluginName) {
        Map<String, Plugin> map = this.pluginMap;
        synchronized (map) {
            Plugin plugin = this.pluginMap.get(pluginName);
            if (plugin == null) {
                return null;
            }
            plugin.shutdown();
            this.pluginMap.remove(pluginName);
            this.firePluginStopped(plugin);
            return plugin;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAllPlugins() {
        Map<String, Plugin> map = this.pluginMap;
        synchronized (map) {
            this.loggerRepository.removeLoggerRepositoryEventListener(this.listener);
            Iterator<Plugin> iterator = this.pluginMap.values().iterator();
            while (iterator.hasNext()) {
                Plugin o;
                Plugin plugin = o = iterator.next();
                plugin.shutdown();
                this.firePluginStopped(plugin);
            }
        }
    }

    public void addPluginListener(PluginListener l) {
        this.listenerList.add(l);
    }

    public void removePluginListener(PluginListener l) {
        this.listenerList.remove(l);
    }

    private class RepositoryListener
    implements LoggerRepositoryEventListener {
        private RepositoryListener() {
        }

        @Override
        public void configurationResetEvent(LoggerRepository repository) {
            PluginRegistry.this.stopAllPlugins();
        }

        @Override
        public void configurationChangedEvent(LoggerRepository repository) {
        }

        @Override
        public void shutdownEvent(LoggerRepository repository) {
            PluginRegistry.this.stopAllPlugins();
        }
    }
}

