/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.xml;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import org.apache.log4j.plugins.Receiver;
import org.apache.log4j.rule.ExpressionRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.Decoder;
import org.apache.log4j.spi.LoggingEvent;

public class LogFileXMLReceiver
extends Receiver {
    private String fileURL;
    private Rule expressionRule;
    private String filterExpression;
    private String decoder = "org.apache.log4j.xml.XMLDecoder";
    private boolean tailing = false;
    private Decoder decoderInstance;
    private Reader reader;
    private static final String FILE_KEY = "file";
    private String host;
    private String path;
    private boolean useCurrentThread;

    public String getFileURL() {
        return this.fileURL;
    }

    public void setFileURL(String fileURL) {
        this.fileURL = fileURL;
    }

    public String getDecoder() {
        return this.decoder;
    }

    public void setDecoder(String _decoder) {
        this.decoder = _decoder;
    }

    public String getFilterExpression() {
        return this.filterExpression;
    }

    public boolean isTailing() {
        return this.tailing;
    }

    public void setTailing(boolean tailing) {
        this.tailing = tailing;
    }

    public void setFilterExpression(String filterExpression) {
        this.filterExpression = filterExpression;
    }

    private boolean passesExpression(LoggingEvent event) {
        if (event != null && this.expressionRule != null) {
            return this.expressionRule.evaluate(event, null);
        }
        return true;
    }

    public static void main(String[] args) {
    }

    @Override
    public void shutdown() {
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    @Override
    public void activateOptions() {
        Runnable runnable = () -> {
            try {
                URL url = new URL(this.fileURL);
                this.host = url.getHost();
                if (this.host != null && this.host.equals("")) {
                    this.host = FILE_KEY;
                }
                this.path = url.getPath();
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
            try {
                if (this.filterExpression != null) {
                    this.expressionRule = ExpressionRule.getRule(this.filterExpression);
                }
            }
            catch (Exception e) {
                this.getLogger().warn((Object)("Invalid filter expression: " + this.filterExpression), e);
            }
            try {
                Class<?> c = Class.forName(this.decoder);
                Object o = c.newInstance();
                if (o instanceof Decoder) {
                    this.decoderInstance = (Decoder)o;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
            try {
                this.reader = new InputStreamReader(new URL(this.getFileURL()).openStream());
                this.process(this.reader);
            }
            catch (FileNotFoundException fnfe) {
                this.getLogger().info("file not available");
            }
            catch (IOException ioe) {
                this.getLogger().warn((Object)"unable to load file", ioe);
                return;
            }
        };
        if (this.useCurrentThread) {
            runnable.run();
        } else {
            Thread thread = new Thread(runnable, "LogFileXMLReceiver-" + this.getName());
            thread.start();
        }
    }

    private void process(Reader unbufferedReader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(unbufferedReader);
        char[] content = new char[10000];
        this.getLogger().debug("processing starting: " + this.fileURL);
        do {
            int length;
            System.out.println("in do loop-about to process");
            while ((length = bufferedReader.read(content)) > -1) {
                this.processEvents(this.decoderInstance.decodeEvents(String.valueOf(content, 0, length)));
            }
            if (!this.tailing) continue;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (this.tailing);
        this.getLogger().debug("processing complete: " + this.fileURL);
        this.shutdown();
    }

    private void processEvents(Collection<LoggingEvent> c) {
        if (c == null) {
            return;
        }
        for (LoggingEvent aC : c) {
            LoggingEvent evt = aC;
            if (!this.passesExpression(evt)) continue;
            if (evt.getProperty("hostname") != null) {
                evt.setProperty("hostname", this.host);
            }
            if (evt.getProperty("application") != null) {
                evt.setProperty("application", this.path);
            }
            this.doPost(evt);
        }
    }

    public final boolean isUseCurrentThread() {
        return this.useCurrentThread;
    }

    public final void setUseCurrentThread(boolean useCurrentThread) {
        this.useCurrentThread = useCurrentThread;
    }
}

