/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.myfaces.commons.converter;

import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import java.util.Locale;


// Generated from class org.apache.myfaces.commons.converter.AbstractTypedNumberConverter.
//
// WARNING: This file was automatically generated. Do not edit it directly,
//          or you will lose your changes.
public class TypedNumberConverter extends org.apache.myfaces.commons.converter.AbstractTypedNumberConverter
{

    static public final String CONVERTER_ID = 
        "org.apache.myfaces.custom.convertNumber.TypedNumberConverter";

    public TypedNumberConverter()
    {
    }


    // Property: groupingUsed
    public boolean isGroupingUsed()
    {
        return (Boolean) getStateHelper().eval(PropertyKeys.groupingUsed, true);
    }
    
    public void setGroupingUsed(boolean groupingUsed)
    {
        getStateHelper().put(PropertyKeys.groupingUsed, groupingUsed ); 
    }    

    // Property: integerOnly
    public boolean isIntegerOnly()
    {
        return (Boolean) getStateHelper().eval(PropertyKeys.integerOnly, false);
    }
    
    public void setIntegerOnly(boolean integerOnly)
    {
        getStateHelper().put(PropertyKeys.integerOnly, integerOnly ); 
    }    

    // Property: maxFractionDigits
    public Integer getMaxFractionDigits()
    {
        return (Integer) getStateHelper().eval(PropertyKeys.maxFractionDigits);
    }
    
    public void setMaxFractionDigits(Integer maxFractionDigits)
    {
        getStateHelper().put(PropertyKeys.maxFractionDigits, maxFractionDigits ); 
    }    

    // Property: maxIntegerDigits
    public Integer getMaxIntegerDigits()
    {
        return (Integer) getStateHelper().eval(PropertyKeys.maxIntegerDigits);
    }
    
    public void setMaxIntegerDigits(Integer maxIntegerDigits)
    {
        getStateHelper().put(PropertyKeys.maxIntegerDigits, maxIntegerDigits ); 
    }    

    // Property: minFractionDigits
    public Integer getMinFractionDigits()
    {
        return (Integer) getStateHelper().eval(PropertyKeys.minFractionDigits);
    }
    
    public void setMinFractionDigits(Integer minFractionDigits)
    {
        getStateHelper().put(PropertyKeys.minFractionDigits, minFractionDigits ); 
    }    

    // Property: minIntegerDigits
    public Integer getMinIntegerDigits()
    {
        return (Integer) getStateHelper().eval(PropertyKeys.minIntegerDigits);
    }
    
    public void setMinIntegerDigits(Integer minIntegerDigits)
    {
        getStateHelper().put(PropertyKeys.minIntegerDigits, minIntegerDigits ); 
    }    

    // Property: pattern
    public String getPattern()
    {
        return (String) getStateHelper().eval(PropertyKeys.pattern);
    }
    
    public void setPattern(String pattern)
    {
        getStateHelper().put(PropertyKeys.pattern, pattern ); 
    }    

    // Property: type
    public String getType()
    {
        return (String) getStateHelper().eval(PropertyKeys.type, "number");
    }
    
    public void setType(String type)
    {
        getStateHelper().put(PropertyKeys.type, type ); 
    }    

    enum PropertyKeys
    {

         groupingUsed
        , integerOnly
        , maxFractionDigits
        , maxIntegerDigits
        , minFractionDigits
        , minIntegerDigits
        , pattern
        , type
    }

 }
