"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cli_options_1 = require("../cli-options");
// dependency section aliases that will be resolved to the full name
const depAliases = {
    dev: 'devDependencies',
    peer: 'peerDependencies',
    prod: 'dependencies',
    optional: 'optionalDependencies',
};
/** Gets a list of dependency sections based on options.dep. */
const resolveDepSections = (options) => {
    const depOptions = options.dep
        ? typeof options.dep === 'string'
            ? options.dep.split(',')
            : options.dep
        : cli_options_1.cliOptionsMap.dep.default;
    // map the dependency section option to a full dependency section name
    const depSections = depOptions.map(name => depAliases[name] || name);
    return depSections;
};
exports.default = resolveDepSections;
//# sourceMappingURL=resolveDep.js.map