"use strict";
/*! Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const mocha_1 = require("mocha");
const mona_dish_1 = require("mona-dish");
const sinon = __importStar(require("sinon"));
const XhrFormData_1 = require("../../impl/xhrCore/XhrFormData");
const chai_1 = require("chai");
const StandardInits_1 = require("../frameworkBase/_ext/shared/StandardInits");
var defaultMyFaces = StandardInits_1.StandardInits.defaultMyFaces;
const AjaxImpl_1 = require("../../impl/AjaxImpl");
const jsdom = require("jsdom");
const { JSDOM } = jsdom;
(0, mocha_1.describe)('XhrFormData tests', function () {
    let oldFlatMap = null;
    beforeEach(function () {
        return __awaiter(this, void 0, void 0, function* () {
            let waitForResult = defaultMyFaces();
            return waitForResult.then((close) => {
                this.xhr = sinon.useFakeXMLHttpRequest();
                this.requests = [];
                this.xhr.onCreate = (xhr) => {
                    this.requests.push(xhr);
                };
                global.XMLHttpRequest = this.xhr;
                window.XMLHttpRequest = this.xhr;
                this.jsfAjaxResponse = sinon.spy(global.faces.ajax, "response");
                oldFlatMap = Array.prototype["flatMap"];
                window["Es2019Array"] = mona_dish_1._Es2019Array;
                delete Array.prototype["flatMap"];
                this.closeIt = () => {
                    global.XMLHttpRequest = window.XMLHttpRequest = this.xhr.restore();
                    this.jsfAjaxResponse.restore();
                    AjaxImpl_1.Implementation.reset();
                    close();
                    if (oldFlatMap) {
                        Array.prototype["flatMap"] = oldFlatMap;
                        oldFlatMap = null;
                    }
                };
            });
        });
    });
    beforeEach(function () {
        let waitForResult = defaultMyFaces();
        return waitForResult.then((close) => {
            global.window = window;
            global.body = window.document.body;
            global.document = window.document;
            global.body.innerHTML = `
      <div id="id_1"></div>
      <div id="id_2" booga="blarg"></div>
      <div id="id_3"></div>
      <div id="id_4"></div>
    `;
            global.navigator = {
                language: "en-En"
            };
            this.xhr = sinon.useFakeXMLHttpRequest();
            this.requests = [];
            this.xhr.onCreate = (xhr) => {
                this.requests.push(xhr);
            };
            global.XMLHttpRequest = this.xhr;
            window.XMLHttpRequest = this.xhr;
        });
        this.afterEach(function () {
            global.XMLHttpRequest = window.XMLHttpRequest = this.xhr.restore();
        });
    });
    (0, mocha_1.it)("must have multiple values for a name", function () {
        window.document.body.innerHTML = `<form id="page::form">
      <tobago-select-many-checkbox id="page:animals">
        <label for="page:animals">Checkbox Group</label>
        <label><input type="checkbox" name="page:animals" id="page:animals::0" value="Cat" checked="checked">Cat</label>
        <label><input type="checkbox" name="page:animals" id="page:animals::1" value="Dog">Dog</label>
        <label><input type="checkbox" name="page:animals" id="page:animals::2" value="Fox" checked="checked">Fox</label>
        <label><input type="checkbox" name="page:animals" id="page:animals::3" value="Rabbit">Rabbit</label>
      </tobago-select-many-checkbox>
      <div id="page:animalsOutput">
        <label for="page:animalsOutput">Selected Animals</label>
        <span>Cat, Fox</span>
      </div>
    </form>`;
        global.debugf2 = true;
        const xhrFormData = new XhrFormData_1.XhrFormData(mona_dish_1.DQ.byId("page::form"));
        const formData = xhrFormData.toString();
        (0, chai_1.expect)(formData).to.contain("animals=Cat");
        (0, chai_1.expect)(formData).to.contain("animals=Fox");
    });
});
//# sourceMappingURL=XhrFormDataTest.spec.js.map