/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.git.ui.repository;

import java.awt.EventQueue;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

/**
 *
 * @author ondra
 */
public class RevisionPickerDialog extends javax.swing.JPanel {
    private final RevisionInfoPanel infoPanel;
    private final RepositoryBrowserPanel browserPanel;
    private int sliderPos;

    /** Creates new form RevisionPickerDialog */
    public RevisionPickerDialog (RevisionInfoPanel infoPanel, RepositoryBrowserPanel browserPanel) {
        this.infoPanel = infoPanel;
        this.browserPanel = browserPanel;
        initComponents();
        browserPanel.addAncestorListener(new AncestorListener() {

            @Override
            public void ancestorAdded (AncestorEvent event) {
                RevisionPickerDialog.this.browserPanel.removeAncestorListener(this);
                if (sliderPos > 0) {
                    EventQueue.invokeLater(new Runnable() {

                        @Override
                        public void run () {
                            jSplitPane1.setDividerLocation(sliderPos);
                        }

                    });
                }
            }

            @Override
            public void ancestorRemoved (AncestorEvent event) {
            }

            @Override
            public void ancestorMoved (AncestorEvent event) {
            }

        });
    }
    
    void setSliderPosition (int pos) {
        this.sliderPos = pos;
        jSplitPane1.setDividerLocation(pos);
    }
    
    int getSliderPosition () {
        return jSplitPane1.getDividerLocation();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jSplitPane1 = new javax.swing.JSplitPane();
        org.netbeans.modules.git.ui.repository.RevisionInfoPanel revisionInfoPanel1 = infoPanel;
        org.netbeans.modules.git.ui.repository.RepositoryBrowserPanel repositoryBrowserPanel1 = browserPanel;

        jSplitPane1.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);
        jSplitPane1.setResizeWeight(0.9);
        jSplitPane1.setRightComponent(revisionInfoPanel1);
        jSplitPane1.setLeftComponent(repositoryBrowserPanel1);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jSplitPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 631, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jSplitPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 427, Short.MAX_VALUE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JSplitPane jSplitPane1;
    // End of variables declaration//GEN-END:variables

}
