/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.MessageInterpolator;
import org.apache.bval.jsr303.util.SecureActions;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMessageInterpolator
implements MessageInterpolator {
    private static final Logger log = LoggerFactory.getLogger(DefaultMessageInterpolator.class);
    private static final String DEFAULT_VALIDATION_MESSAGES = "org.apache.bval.jsr303.ValidationMessages";
    private static final String USER_VALIDATION_MESSAGES = "ValidationMessages";
    private static final Pattern messageParameterPattern = Pattern.compile("(\\{[\\w\\.]+\\})");
    private Locale defaultLocale;
    private final Map<Locale, ResourceBundle> userBundlesMap = new ConcurrentHashMap<Locale, ResourceBundle>();
    private final Map<Locale, ResourceBundle> defaultBundlesMap = new ConcurrentHashMap<Locale, ResourceBundle>();

    public DefaultMessageInterpolator() {
        this(null);
    }

    public DefaultMessageInterpolator(ResourceBundle resourceBundle) {
        this.defaultLocale = Locale.getDefault();
        if (resourceBundle == null) {
            ResourceBundle bundle = this.getFileBasedResourceBundle(this.defaultLocale);
            if (bundle != null) {
                this.userBundlesMap.put(this.defaultLocale, bundle);
            }
        } else {
            this.userBundlesMap.put(this.defaultLocale, resourceBundle);
        }
        this.defaultBundlesMap.put(this.defaultLocale, ResourceBundle.getBundle(DEFAULT_VALIDATION_MESSAGES, this.defaultLocale));
    }

    public String interpolate(String message, MessageInterpolator.Context context) {
        return this.interpolate(message, context, this.defaultLocale);
    }

    public String interpolate(String message, MessageInterpolator.Context context, Locale locale) {
        return this.interpolateMessage(message, context.getConstraintDescriptor().getAttributes(), locale);
    }

    private String interpolateMessage(String message, Map<String, Object> annotationParameters, Locale locale) {
        ResourceBundle userResourceBundle = this.findUserResourceBundle(locale);
        ResourceBundle defaultResourceBundle = this.findDefaultResourceBundle(locale);
        String resolvedMessage = message;
        boolean evaluatedDefaultBundleOnce = false;
        while (true) {
            String userBundleResolvedMessage = this.replaceVariables(resolvedMessage, userResourceBundle, locale, true);
            if (evaluatedDefaultBundleOnce && !this.hasReplacementTakenPlace(userBundleResolvedMessage, resolvedMessage)) break;
            resolvedMessage = this.replaceVariables(userBundleResolvedMessage, defaultResourceBundle, locale, false);
            evaluatedDefaultBundleOnce = true;
        }
        resolvedMessage = this.replaceAnnotationAttributes(resolvedMessage, annotationParameters);
        resolvedMessage = resolvedMessage.replace("\\{", "{").replace("\\}", "}").replace("\\\\", "\\");
        return resolvedMessage;
    }

    private boolean hasReplacementTakenPlace(String origMessage, String newMessage) {
        return !origMessage.equals(newMessage);
    }

    private ResourceBundle getFileBasedResourceBundle(Locale locale) {
        ResourceBundle rb = null;
        ClassLoader classLoader = SecureActions.getContextClassLoader(Thread.currentThread());
        if (classLoader != null) {
            rb = this.loadBundle(classLoader, locale, "ValidationMessages not found by thread local classloader");
        }
        if (rb == null) {
            rb = this.loadBundle(SecureActions.getClassLoader(this.getClass()), locale, "ValidationMessages not found by validator classloader");
        }
        if (rb != null) {
            log.debug("{} found", (Object)USER_VALIDATION_MESSAGES);
        } else {
            log.debug("{} not found. Delegating to {}", (Object)USER_VALIDATION_MESSAGES, (Object)DEFAULT_VALIDATION_MESSAGES);
        }
        return rb;
    }

    private ResourceBundle loadBundle(ClassLoader classLoader, Locale locale, String message) {
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle(USER_VALIDATION_MESSAGES, locale, classLoader);
        }
        catch (MissingResourceException e) {
            log.trace(message);
        }
        return rb;
    }

    private String replaceVariables(String message, ResourceBundle bundle, Locale locale, boolean recurse) {
        Matcher matcher = messageParameterPattern.matcher(message);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String parameter = matcher.group(1);
            String resolvedParameterValue = this.resolveParameter(parameter, bundle, locale, recurse);
            matcher.appendReplacement(sb, this.sanitizeForAppendReplacement(resolvedParameterValue));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String replaceAnnotationAttributes(String message, Map<String, Object> annotationParameters) {
        Matcher matcher = messageParameterPattern.matcher(message);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String parameter = matcher.group(1);
            Object variable = annotationParameters.get(this.removeCurlyBrace(parameter));
            String resolvedParameterValue = variable != null ? (variable.getClass().isArray() ? ArrayUtils.toString((Object)variable) : variable.toString()) : parameter;
            matcher.appendReplacement(sb, this.sanitizeForAppendReplacement(resolvedParameterValue));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String resolveParameter(String parameterName, ResourceBundle bundle, Locale locale, boolean recurse) {
        String parameterValue;
        try {
            if (bundle != null) {
                parameterValue = bundle.getString(this.removeCurlyBrace(parameterName));
                if (recurse) {
                    parameterValue = this.replaceVariables(parameterValue, bundle, locale, recurse);
                }
            } else {
                parameterValue = parameterName;
            }
        }
        catch (MissingResourceException e) {
            parameterValue = parameterName;
        }
        return parameterValue;
    }

    private String removeCurlyBrace(String parameter) {
        return parameter.substring(1, parameter.length() - 1);
    }

    private ResourceBundle findDefaultResourceBundle(Locale locale) {
        if (this.defaultBundlesMap.containsKey(locale)) {
            return this.defaultBundlesMap.get(locale);
        }
        ResourceBundle bundle = ResourceBundle.getBundle(DEFAULT_VALIDATION_MESSAGES, locale);
        this.defaultBundlesMap.put(locale, bundle);
        return bundle;
    }

    private ResourceBundle findUserResourceBundle(Locale locale) {
        if (this.userBundlesMap.containsKey(locale)) {
            return this.userBundlesMap.get(locale);
        }
        ResourceBundle bundle = this.getFileBasedResourceBundle(locale);
        if (bundle != null) {
            this.userBundlesMap.put(locale, bundle);
        }
        return bundle;
    }

    public void setLocale(Locale locale) {
        this.defaultLocale = locale;
    }

    private String sanitizeForAppendReplacement(String src) {
        return src.replace("\\", "\\\\").replace("$", "\\$");
    }
}

