/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode.lowlevel;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import serp.bytecode.lowlevel.ClassEntry;
import serp.bytecode.lowlevel.ComplexEntry;
import serp.bytecode.lowlevel.ConstantEntry;
import serp.bytecode.lowlevel.DoubleEntry;
import serp.bytecode.lowlevel.Entry;
import serp.bytecode.lowlevel.FieldEntry;
import serp.bytecode.lowlevel.FloatEntry;
import serp.bytecode.lowlevel.IntEntry;
import serp.bytecode.lowlevel.InterfaceMethodEntry;
import serp.bytecode.lowlevel.InvokeDynamicEntry;
import serp.bytecode.lowlevel.LongEntry;
import serp.bytecode.lowlevel.MethodEntry;
import serp.bytecode.lowlevel.NameAndTypeEntry;
import serp.bytecode.lowlevel.StringEntry;
import serp.bytecode.lowlevel.UTF8Entry;
import serp.bytecode.visitor.BCVisitor;
import serp.bytecode.visitor.VisitAcceptor;
import serp.util.Numbers;

public class ConstantPool
implements VisitAcceptor {
    private List _entries = new ArrayList(50);
    private Map _lookup = new HashMap(50);

    public Entry[] getEntries() {
        ArrayList<Entry> entries = new ArrayList<Entry>(this._entries.size());
        for (Entry entry : this._entries) {
            if (entry == null) continue;
            entries.add(entry);
        }
        return entries.toArray(new Entry[entries.size()]);
    }

    public Entry getEntry(int index) {
        Entry entry = (Entry)this._entries.get(index - 1);
        if (entry == null) {
            throw new IndexOutOfBoundsException("index = " + index);
        }
        return entry;
    }

    public int indexOf(Entry entry) {
        if (entry == null || entry.getPool() != this) {
            return 0;
        }
        return entry.getIndex();
    }

    public int addEntry(Entry entry) {
        if (entry.getPool() != this) {
            this.addEntry(ConstantPool.getKey(entry), entry);
        }
        return entry.getIndex();
    }

    private int addEntry(Object key, Entry entry) {
        entry.setPool(this);
        this._entries.add(entry);
        entry.setIndex(this._entries.size());
        this._lookup.put(key, entry);
        if (entry.isWide()) {
            this._entries.add(null);
        }
        return entry.getIndex();
    }

    public boolean removeEntry(Entry entry) {
        if (entry == null || entry.getPool() != this) {
            return false;
        }
        int index = entry.getIndex() - 1;
        entry.setPool(null);
        entry.setIndex(0);
        this._entries.remove(index);
        if (entry.isWide()) {
            this._entries.remove(index);
        }
        this._lookup.remove(ConstantPool.getKey(entry));
        for (int i = index; i < this._entries.size(); ++i) {
            entry = (Entry)this._entries.get(i);
            if (entry == null) continue;
            Object key = ConstantPool.getKey(entry);
            this._lookup.remove(key);
            entry.setIndex(i + 1);
            this._lookup.put(key, entry);
        }
        return true;
    }

    public void clear() {
        for (Entry entry : this._entries) {
            if (entry == null) continue;
            entry.setPool(null);
            entry.setIndex(0);
        }
        this._entries.clear();
        this._lookup.clear();
    }

    public int size() {
        return this._entries.size();
    }

    public int findUTF8Entry(String value, boolean add) {
        if (value == null) {
            if (add) {
                throw new NullPointerException("value = null");
            }
            return 0;
        }
        int index = this.find(value);
        if (!add || index > 0) {
            return index;
        }
        return this.addEntry(value, new UTF8Entry(value));
    }

    public int findDoubleEntry(double value, boolean add) {
        Double key = new Double(value);
        int index = this.find(key);
        if (!add || index > 0) {
            return index;
        }
        return this.addEntry(key, new DoubleEntry(value));
    }

    public int findFloatEntry(float value, boolean add) {
        Float key = new Float(value);
        int index = this.find(key);
        if (!add || index > 0) {
            return index;
        }
        return this.addEntry(key, new FloatEntry(value));
    }

    public int findIntEntry(int value, boolean add) {
        Integer key = Numbers.valueOf(value);
        int index = this.find(key);
        if (!add || index > 0) {
            return index;
        }
        return this.addEntry(key, new IntEntry(value));
    }

    public int findLongEntry(long value, boolean add) {
        Long key = Numbers.valueOf(value);
        int index = this.find(key);
        if (!add || index > 0) {
            return index;
        }
        return this.addEntry(key, new LongEntry(value));
    }

    public int findStringEntry(String value, boolean add) {
        int valueIndex = this.findUTF8Entry(value, add);
        if (valueIndex == 0) {
            return 0;
        }
        StringKey key = new StringKey(valueIndex);
        int index = this.find(key);
        if (!add || index > 0) {
            return index;
        }
        return this.addEntry(key, new StringEntry(valueIndex));
    }

    public int findClassEntry(String name, boolean add) {
        int nameIndex = this.findUTF8Entry(name, add);
        if (nameIndex == 0) {
            return 0;
        }
        ClassKey key = new ClassKey(nameIndex);
        int index = this.find(key);
        if (!add || index > 0) {
            return index;
        }
        return this.addEntry(key, new ClassEntry(nameIndex));
    }

    public int findNameAndTypeEntry(String name, String desc, boolean add) {
        int nameIndex = this.findUTF8Entry(name, add);
        if (nameIndex == 0) {
            return 0;
        }
        int descIndex = this.findUTF8Entry(desc, add);
        if (descIndex == 0) {
            return 0;
        }
        NameAndTypeKey key = new NameAndTypeKey(nameIndex, descIndex);
        int index = this.find(key);
        if (!add || index > 0) {
            return index;
        }
        return this.addEntry(key, new NameAndTypeEntry(nameIndex, descIndex));
    }

    public int findFieldEntry(String owner, String name, String desc, boolean add) {
        return this.findComplexEntry(owner, name, desc, 9, add);
    }

    public int findMethodEntry(String owner, String name, String desc, boolean add) {
        return this.findComplexEntry(owner, name, desc, 10, add);
    }

    public int findInterfaceMethodEntry(String owner, String name, String desc, boolean add) {
        return this.findComplexEntry(owner, name, desc, 11, add);
    }

    public int findInvokeDynamicEntry(int bootstrapMethodIndex, String name, String desc, boolean add) {
        int descIndex = this.findNameAndTypeEntry(name, desc, add);
        if (descIndex == 0) {
            return 0;
        }
        InvokeDynamicKey key = new InvokeDynamicKey(bootstrapMethodIndex, descIndex);
        int index = this.find(key);
        if (!add || index > 0) {
            return index;
        }
        InvokeDynamicEntry entry = new InvokeDynamicEntry(bootstrapMethodIndex, descIndex);
        return this.addEntry(key, entry);
    }

    private int findComplexEntry(String owner, String name, String desc, int type, boolean add) {
        int classIndex = this.findClassEntry(owner, add);
        if (classIndex == 0) {
            return 0;
        }
        int descIndex = this.findNameAndTypeEntry(name, desc, add);
        if (descIndex == 0) {
            return 0;
        }
        DoublePtrKey key = null;
        switch (type) {
            case 9: {
                key = new FieldKey(classIndex, descIndex);
                break;
            }
            case 10: {
                key = new MethodKey(classIndex, descIndex);
                break;
            }
            case 11: {
                key = new InterfaceMethodKey(classIndex, descIndex);
            }
        }
        int index = this.find(key);
        if (!add || index > 0) {
            return index;
        }
        ComplexEntry entry = null;
        switch (type) {
            case 9: {
                entry = new FieldEntry(classIndex, descIndex);
                break;
            }
            case 10: {
                entry = new MethodEntry(classIndex, descIndex);
                break;
            }
            case 11: {
                entry = new InterfaceMethodEntry(classIndex, descIndex);
            }
        }
        return this.addEntry(key, entry);
    }

    @Override
    public void acceptVisit(BCVisitor visit) {
        visit.enterConstantPool(this);
        for (Entry entry : this._entries) {
            if (entry == null) continue;
            visit.enterEntry(entry);
            entry.acceptVisit(visit);
            visit.exitEntry(entry);
        }
        visit.exitConstantPool(this);
    }

    public void read(DataInput in) throws IOException {
        this.clear();
        int entryCount = in.readUnsignedShort();
        for (int i = 1; i < entryCount; ++i) {
            Entry entry = Entry.read(in);
            this.addEntry(entry);
            if (!entry.isWide()) continue;
            ++i;
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeShort(this._entries.size() + 1);
        for (Entry entry : this._entries) {
            if (entry == null) continue;
            Entry.write(entry, out);
        }
    }

    void modifyEntry(Object origKey, Entry entry) {
        this._lookup.remove(origKey);
        this._lookup.put(ConstantPool.getKey(entry), entry);
    }

    private int find(Object key) {
        Entry entry = (Entry)this._lookup.get(key);
        if (entry == null) {
            return 0;
        }
        return entry.getIndex();
    }

    static Object getKey(Entry entry) {
        switch (entry.getType()) {
            case 7: {
                return new ClassKey(((ClassEntry)entry).getNameIndex());
            }
            case 9: {
                FieldEntry fe = (FieldEntry)entry;
                return new FieldKey(fe.getClassIndex(), fe.getNameAndTypeIndex());
            }
            case 10: {
                MethodEntry me = (MethodEntry)entry;
                return new MethodKey(me.getClassIndex(), me.getNameAndTypeIndex());
            }
            case 11: {
                InterfaceMethodEntry ime = (InterfaceMethodEntry)entry;
                return new InterfaceMethodKey(ime.getClassIndex(), ime.getNameAndTypeIndex());
            }
            case 18: {
                InvokeDynamicEntry ide = (InvokeDynamicEntry)entry;
                return new InvokeDynamicKey(ide.getBootstrapMethodAttrIndex(), ide.getNameAndTypeIndex());
            }
            case 8: {
                return new StringKey(((StringEntry)entry).getStringIndex());
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return ((ConstantEntry)((Object)entry)).getConstant();
            }
            case 12: {
                NameAndTypeEntry nte = (NameAndTypeEntry)entry;
                return new NameAndTypeKey(nte.getNameIndex(), nte.getDescriptorIndex());
            }
        }
        return null;
    }

    private static class InvokeDynamicKey
    extends DoublePtrKey {
        public InvokeDynamicKey(int index1, int index2) {
            super(index1, index2);
        }
    }

    private static class InterfaceMethodKey
    extends DoublePtrKey {
        public InterfaceMethodKey(int index1, int index2) {
            super(index1, index2);
        }
    }

    private static class MethodKey
    extends DoublePtrKey {
        public MethodKey(int index1, int index2) {
            super(index1, index2);
        }
    }

    private static class FieldKey
    extends DoublePtrKey {
        public FieldKey(int index1, int index2) {
            super(index1, index2);
        }
    }

    private static class NameAndTypeKey
    extends DoublePtrKey {
        public NameAndTypeKey(int index1, int index2) {
            super(index1, index2);
        }
    }

    private static abstract class DoublePtrKey {
        private final int _index1;
        private final int _index2;

        public DoublePtrKey(int index1, int index2) {
            this._index1 = index1;
            this._index2 = index2;
        }

        public int hashCode() {
            return this._index1 ^ this._index2;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            DoublePtrKey key = (DoublePtrKey)other;
            return key._index1 == this._index1 && key._index2 == this._index2;
        }
    }

    private static class ClassKey
    extends PtrKey {
        public ClassKey(int index) {
            super(index);
        }
    }

    private static class StringKey
    extends PtrKey {
        public StringKey(int index) {
            super(index);
        }
    }

    private static abstract class PtrKey {
        private final int _index;

        public PtrKey(int index) {
            this._index = index;
        }

        public int hashCode() {
            return this._index;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            return ((PtrKey)other)._index == this._index;
        }
    }
}

