/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.openjpa.kernel;

import org.apache.openjpa.enhance.UnenhancedPropertyAccess;
import org.apache.openjpa.enhance.UnenhancedPropertyAccessSubclass;
import org.apache.openjpa.persistence.test.AllowFailure;

@AllowFailure(message="excluded")
public class TestUnenhancedPropertyAccessWithRelationInstanceBrokerSerialization
    extends AbstractUnenhancedRelationBrokerSerializationTest
        <UnenhancedPropertyAccessSubclass> {

    @Override
    protected Class getSecondaryType() {
        return UnenhancedPropertyAccess.class;
    }

    @Override
    protected Class<UnenhancedPropertyAccessSubclass> getManagedType() {
        return UnenhancedPropertyAccessSubclass.class;
    }

    @Override
    protected UnenhancedPropertyAccessSubclass newManagedInstance() {
        UnenhancedPropertyAccessSubclass e =
            new UnenhancedPropertyAccessSubclass();
        e.setStringField("foo");
        UnenhancedPropertyAccess related = new UnenhancedPropertyAccess();
        related.setStringField("bar");
        e.setRelated(related);
        return e;
    }

    @Override
    protected void modifyInstance(UnenhancedPropertyAccessSubclass e) {
        e.getRelated().setStringField("modified");
    }

    @Override
    protected Object getModifiedValue(UnenhancedPropertyAccessSubclass e) {
        return e.getRelated().getStringField();
    }

    @Override
    protected int graphSize() {
        return 2;
    }
}
