/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.jms.component;

import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import jakarta.jms.TopicSubscriber;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import org.apache.webbeans.component.BeanAttributesImpl;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.jms.JMSModel;
import org.apache.webbeans.jms.component.JmsBean;
import org.apache.webbeans.util.Asserts;

public final class JmsComponentFactory {
    private static JmsComponentFactory instance = new JmsComponentFactory();

    private JmsComponentFactory() {
    }

    public static JmsComponentFactory getJmsComponentFactory() {
        return instance;
    }

    public <T> JmsBean<T> getJmsComponent(WebBeansContext webBeansContext, JMSModel model) {
        Annotation[] anns;
        Asserts.assertNotNull((Object)model, (String)"model parameter");
        HashSet<Class> apiTypes = new HashSet<Class>();
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        if (model.getJmsType() == JMSModel.JMSType.QUEUE) {
            apiTypes.add(Queue.class);
            apiTypes.add(QueueConnection.class);
            apiTypes.add(QueueSession.class);
            apiTypes.add(QueueSender.class);
            apiTypes.add(QueueReceiver.class);
        } else {
            apiTypes.add(Topic.class);
            apiTypes.add(TopicConnection.class);
            apiTypes.add(TopicSession.class);
            apiTypes.add(TopicPublisher.class);
            apiTypes.add(TopicSubscriber.class);
        }
        for (Annotation a : anns = model.getBindings()) {
            qualifiers.add(a);
        }
        return new JmsBean(webBeansContext, model, new BeanAttributesImpl(apiTypes, qualifiers));
    }
}

