/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.w3c.domts.DOMTest.load;


/**
 * The method createElementNS creates an element of the given valid qualifiedName and NamespaceURI.
 * <p>
 * Invoke the createElementNS method on this Document object with a valid namespaceURI
 * and qualifiedName.  Check if a valid Element object is returned with the same node attributes.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core">http://www.w3.org/TR/DOM-Level-2-Core/core</a>
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-DocCrElNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-DocCrElNS</a>
 */
public class documentcreateelementNS01 {
    @Test
    void testRun() throws Throwable {
        String namespaceURI = "http://www.w3.org/DOM/Test/level2";
        String qualifiedName = "XML:XML";
        Document doc = load("staffNS", false);
        Element element = doc.createElementNS(namespaceURI, qualifiedName);
        String nodeName = element.getNodeName();
        String nsURI = element.getNamespaceURI();
        String localName = element.getLocalName();
        String prefix = element.getPrefix();
        String tagName = element.getTagName();
        assertEquals("XML:XML", nodeName, "documentcreateelementNS01_nodeName");
        assertEquals("http://www.w3.org/DOM/Test/level2", nsURI, "documentcreateelementNS01_namespaceURI");
        assertEquals("XML", localName, "documentcreateelementNS01_localName");
        assertEquals("XML", prefix, "documentcreateelementNS01_prefix");
        assertEquals("XML:XML", tagName, "documentcreateelementNS01_tagName");

    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/documentcreateelementNS01";
    }

}
