/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertThrows;
import static org.w3c.domts.DOMTest.load;


/**
 * The method setPrefix raises a INVALID_CHARACTER_ERR if the specified prefix contains an illegal character.
 * Create a new namespace aware element node and call the setPrefix method on it with a prefix having
 * an invalid character.  Check if a NAMESPACE_ERR is thrown.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-NodeNSPrefix">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-NodeNSPrefix</a>
 */
public class nodesetprefix09 {
    @Test
    void testRun() throws Throwable {
        String value = "#$%&'()@";
        Document doc = load("staffNS", true);
        Element element = doc.createElementNS("http://www.w3.org/DOM/Test/L2", "dom:elem");

        DOMException ex = assertThrows(DOMException.class, () -> element.setPrefix(value));
        assertEquals(DOMException.INVALID_CHARACTER_ERR, ex.code, "nodesetprefix09");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/nodesetprefix09";
    }

}
