/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance;

import com.netflix.config.DynamicPropertyFactory;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.reactive.ExecutionContext;
import com.netflix.loadbalancer.reactive.ExecutionInfo;
import com.netflix.loadbalancer.reactive.ExecutionListener;
import com.netflix.loadbalancer.reactive.LoadBalancerCommand;
import com.netflix.loadbalancer.reactive.ServerOperation;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.Transport;
import org.apache.servicecomb.core.provider.consumer.SyncResponseExecutor;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.common.utils.ExceptionUtils;
import org.apache.servicecomb.loadbalance.Configuration;
import org.apache.servicecomb.loadbalance.ExtensionsManager;
import org.apache.servicecomb.loadbalance.LoadBalancer;
import org.apache.servicecomb.loadbalance.RuleExt;
import org.apache.servicecomb.loadbalance.ServiceCombLoadBalancerStats;
import org.apache.servicecomb.loadbalance.ServiceCombServer;
import org.apache.servicecomb.loadbalance.ServiceCombServerStats;
import org.apache.servicecomb.loadbalance.filter.ServerDiscoveryFilter;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryContext;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryFilter;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryTree;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryTreeNode;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class LoadbalanceHandler
implements Handler {
    public static final String CONTEXT_KEY_SERVER_LIST = "x-context-server-list";
    public static final String SERVICECOMB_SERVER_ENDPOINT = "scb-endpoint";
    public final boolean supportDefinedEndpoint = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.loadbalance.userDefinedEndpoint.enabled", false).get();
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadbalanceHandler.class);
    private static final ExecutorService RETRY_POOL = Executors.newCachedThreadPool(new ThreadFactory(){
        private AtomicInteger count = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "retry-pool-thread-" + this.count.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    });
    private DiscoveryTree discoveryTree = new DiscoveryTree();
    private volatile Map<String, LoadBalancer> loadBalancerMap = new ConcurrentHashMapEx();
    private final Object lock = new Object();
    private String strategy = null;

    public LoadbalanceHandler(DiscoveryTree discoveryTree) {
        this.discoveryTree = discoveryTree;
    }

    public LoadbalanceHandler() {
        this.preCheck();
        this.discoveryTree.loadFromSPI(DiscoveryFilter.class);
        this.discoveryTree.addFilter((DiscoveryFilter)new ServerDiscoveryFilter());
        this.discoveryTree.sort();
    }

    private void preCheck() {
        String filterNames;
        String policyName = DynamicPropertyFactory.getInstance().getStringProperty("servicecomb.loadbalance.NFLoadBalancerRuleClassName", null).get();
        if (!StringUtils.isEmpty((CharSequence)policyName)) {
            LOGGER.error("[servicecomb.loadbalance.NFLoadBalancerRuleClassName] is not supported anymore.use [servicecomb.loadbalance.strategy.name] instead.");
        }
        if (!StringUtils.isEmpty((CharSequence)(filterNames = Configuration.getStringProperty(null, "servicecomb.loadbalance.serverListFilters")))) {
            LOGGER.error("Server list implementation changed to SPI. Configuration [servicecomb.loadbalance.serverListFilters] is not used any more. For ServiceComb defined filters, you do not need config and can remove this configuration safely. If you define your own filter, need to change it to SPI to make it work.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        AsyncResponse response = asyncResp;
        asyncResp = async -> {
            ServiceCombServerStats.checkAndReleaseTryingChance(invocation);
            response.handle(async);
        };
        if (this.supportDefinedEndpoint && this.defineEndpointAndHandle(invocation, asyncResp)) {
            return;
        }
        String strategy = Configuration.INSTANCE.getRuleStrategyName(invocation.getMicroserviceName());
        if (!Objects.equals(strategy, this.strategy)) {
            Object object = this.lock;
            synchronized (object) {
                this.clearLoadBalancer();
            }
        }
        this.strategy = strategy;
        LoadBalancer loadBalancer = this.getOrCreateLoadBalancer(invocation);
        if (!Configuration.INSTANCE.isRetryEnabled(invocation.getMicroserviceName())) {
            this.send(invocation, asyncResp, loadBalancer);
        } else {
            this.sendWithRetry(invocation, asyncResp, loadBalancer);
        }
    }

    private boolean defineEndpointAndHandle(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        String endpointUri = (String)invocation.getLocalContext(SERVICECOMB_SERVER_ENDPOINT);
        if (endpointUri == null) {
            return false;
        }
        URI formatUri = new URI(endpointUri);
        Transport transport = SCBEngine.getInstance().getTransportManager().findTransport(formatUri.getScheme());
        if (transport == null) {
            LOGGER.error("not deployed transport {}, ignore {}.", (Object)formatUri.getScheme(), (Object)endpointUri);
            throw new InvocationException((Response.StatusType)Response.Status.BAD_REQUEST, "the endpoint's transport is not found.");
        }
        Endpoint endpoint = new Endpoint(transport, endpointUri);
        invocation.setEndpoint(endpoint);
        invocation.next(resp -> asyncResp.handle(resp));
        return true;
    }

    private void clearLoadBalancer() {
        this.loadBalancerMap.clear();
    }

    private void send(Invocation invocation, AsyncResponse asyncResp, LoadBalancer chosenLB) throws Exception {
        long time = System.currentTimeMillis();
        ServiceCombServer server = chosenLB.chooseServer(invocation);
        if (null == server) {
            asyncResp.consumerFail((Throwable)new InvocationException((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, "No available address found."));
            return;
        }
        chosenLB.getLoadBalancerStats().incrementNumRequests((Server)server);
        invocation.setEndpoint(server.getEndpoint());
        invocation.next(resp -> {
            chosenLB.getLoadBalancerStats().noteResponseTime((Server)server, (double)(System.currentTimeMillis() - time));
            if (this.isFailedResponse(resp)) {
                chosenLB.getLoadBalancerStats().incrementSuccessiveConnectionFailureCount((Server)server);
                ServiceCombLoadBalancerStats.INSTANCE.markFailure(server);
            } else {
                chosenLB.getLoadBalancerStats().incrementActiveRequestsCount((Server)server);
                ServiceCombLoadBalancerStats.INSTANCE.markSuccess(server);
            }
            asyncResp.handle(resp);
        });
    }

    private void sendWithRetry(final Invocation invocation, final AsyncResponse asyncResp, final LoadBalancer chosenLB) throws Exception {
        SyncResponseExecutor orginExecutor;
        final long time = System.currentTimeMillis();
        final int currentHandler = invocation.getHandlerIndex();
        if (invocation.getResponseExecutor() instanceof SyncResponseExecutor) {
            orginExecutor = (SyncResponseExecutor)invocation.getResponseExecutor();
            Executor newExecutor = new Executor(){

                @Override
                public void execute(Runnable command) {
                    RETRY_POOL.submit(command);
                }
            };
            invocation.setResponseExecutor(newExecutor);
        } else {
            orginExecutor = null;
            Object newExecutor = null;
        }
        ExecutionListener<Invocation, Response> listener = new ExecutionListener<Invocation, Response>(){

            public void onExecutionStart(ExecutionContext<Invocation> context) throws ExecutionListener.AbortExecutionException {
            }

            public void onStartWithServer(ExecutionContext<Invocation> context, ExecutionInfo info) throws ExecutionListener.AbortExecutionException {
            }

            public void onExceptionWithServer(ExecutionContext<Invocation> context, Throwable exception, ExecutionInfo info) {
                LOGGER.error("Invoke server failed. Operation {}; server {}; {}-{} msg {}", new Object[]{((Invocation)context.getRequest()).getInvocationQualifiedName(), ((Invocation)context.getRequest()).getEndpoint(), info.getNumberOfPastServersAttempted(), info.getNumberOfPastAttemptsOnServer(), ExceptionUtils.getExceptionMessageWithoutTrace((Throwable)exception)});
            }

            public void onExecutionSuccess(ExecutionContext<Invocation> context, Response response, ExecutionInfo info) {
                if (info.getNumberOfPastServersAttempted() > 0 || info.getNumberOfPastAttemptsOnServer() > 0) {
                    LOGGER.error("Invoke server success. Operation {}; server {}", (Object)((Invocation)context.getRequest()).getInvocationQualifiedName(), (Object)((Invocation)context.getRequest()).getEndpoint());
                }
                if (orginExecutor != null) {
                    orginExecutor.execute(() -> asyncResp.complete(response));
                } else {
                    asyncResp.complete(response);
                }
            }

            public void onExecutionFailed(ExecutionContext<Invocation> context, Throwable finalException, ExecutionInfo info) {
                LOGGER.error("Invoke all server failed. Operation {}, e={}", (Object)((Invocation)context.getRequest()).getInvocationQualifiedName(), (Object)ExceptionUtils.getExceptionMessageWithoutTrace((Throwable)finalException));
                if (orginExecutor != null) {
                    orginExecutor.execute(() -> this.fail(finalException));
                } else {
                    this.fail(finalException);
                }
            }

            private void fail(Throwable finalException) {
                int depth = 10;
                Throwable t = finalException;
                while (depth-- > 0) {
                    if (t instanceof InvocationException) {
                        asyncResp.consumerFail(t);
                        return;
                    }
                    t = finalException.getCause();
                }
                asyncResp.consumerFail(finalException);
            }
        };
        ArrayList<3> listeners = new ArrayList<3>(0);
        listeners.add(listener);
        ExecutionContext context = new ExecutionContext((Object)invocation, null, null, null);
        LoadBalancerCommand command = LoadBalancerCommand.builder().withLoadBalancer((ILoadBalancer)new RetryLoadBalancer(chosenLB)).withServerLocator((Object)invocation).withRetryHandler(ExtensionsManager.createRetryHandler(invocation.getMicroserviceName())).withListeners(listeners).withExecutionContext(context).build();
        Observable observable = command.submit((ServerOperation)new ServerOperation<Response>(){

            public Observable<Response> call(Server s) {
                return Observable.create(f -> {
                    try {
                        ServiceCombServer server = (ServiceCombServer)s;
                        chosenLB.getLoadBalancerStats().incrementNumRequests(s);
                        invocation.setHandlerIndex(currentHandler);
                        invocation.setEndpoint(server.getEndpoint());
                        invocation.next(resp -> {
                            if (LoadbalanceHandler.this.isFailedResponse(resp)) {
                                LOGGER.error("service {}, call error, msg is {}, server is {} ", new Object[]{invocation.getInvocationQualifiedName(), ExceptionUtils.getExceptionMessageWithoutTrace((Throwable)((Throwable)resp.getResult())), s});
                                chosenLB.getLoadBalancerStats().incrementSuccessiveConnectionFailureCount(s);
                                ServiceCombLoadBalancerStats.INSTANCE.markFailure(server);
                                f.onError((Throwable)resp.getResult());
                            } else {
                                chosenLB.getLoadBalancerStats().incrementActiveRequestsCount(s);
                                chosenLB.getLoadBalancerStats().noteResponseTime(s, (double)(System.currentTimeMillis() - time));
                                ServiceCombLoadBalancerStats.INSTANCE.markSuccess(server);
                                f.onNext((Object)resp);
                                f.onCompleted();
                            }
                        });
                    }
                    catch (Exception e) {
                        LOGGER.error("execution error, msg is {}", (Object)ExceptionUtils.getExceptionMessageWithoutTrace((Throwable)e));
                        f.onError((Throwable)e);
                    }
                });
            }
        });
        observable.subscribe(response -> {}, error -> {}, () -> {});
    }

    protected boolean isFailedResponse(Response resp) {
        if (resp.isFailed()) {
            if (InvocationException.class.isInstance(resp.getResult())) {
                InvocationException e = (InvocationException)resp.getResult();
                return e.getStatusCode() == 490 || e.getStatusCode() == 503 || e.getStatusCode() == Response.Status.REQUEST_TIMEOUT.getStatusCode();
            }
            return true;
        }
        return false;
    }

    protected LoadBalancer getOrCreateLoadBalancer(Invocation invocation) {
        DiscoveryContext context = new DiscoveryContext();
        context.setInputParameters((Object)invocation);
        DiscoveryTreeNode serversVersionedCache = this.discoveryTree.discovery(context, invocation.getAppId(), invocation.getMicroserviceName(), invocation.getMicroserviceVersionRule());
        invocation.addLocalContext(CONTEXT_KEY_SERVER_LIST, serversVersionedCache.data());
        return this.loadBalancerMap.computeIfAbsent(serversVersionedCache.name(), name -> this.createLoadBalancer(invocation.getMicroserviceName()));
    }

    private LoadBalancer createLoadBalancer(String microserviceName) {
        RuleExt rule = ExtensionsManager.createLoadBalancerRule(microserviceName);
        return new LoadBalancer(rule, microserviceName);
    }

    class RetryLoadBalancer
    implements ILoadBalancer {
        static final int COUNT = 17;
        Server lastServer = null;
        LoadBalancer delegate;

        RetryLoadBalancer(LoadBalancer delegate) {
            this.delegate = delegate;
        }

        public void addServers(List<Server> newServers) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public Server chooseServer(Object key) {
            ServiceCombServer s;
            boolean isRetry = null != this.lastServer;
            for (int i = 0; i < 17 && (s = this.delegate.chooseServer((Invocation)key)) != null; ++i) {
                if (s.equals(this.lastServer)) continue;
                this.lastServer = s;
                break;
            }
            if (isRetry) {
                LOGGER.info("retry to instance [{}]", (Object)this.lastServer.getHostPort());
            }
            return this.lastServer;
        }

        public void markServerDown(Server server) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Deprecated
        public List<Server> getServerList(boolean availableOnly) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public List<Server> getReachableServers() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public List<Server> getAllServers() {
            throw new UnsupportedOperationException("Not implemented.");
        }
    }
}

