/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.converter;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.annotations.VisibleForTesting;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.Property;
import java.lang.reflect.Type;
import java.util.IdentityHashMap;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import org.apache.servicecomb.common.javassist.ClassConfig;
import org.apache.servicecomb.common.javassist.CtTypeJavaType;
import org.apache.servicecomb.common.javassist.JavassistUtils;
import org.apache.servicecomb.common.javassist.MethodConfig;
import org.apache.servicecomb.swagger.converter.ConverterMgr;
import org.apache.servicecomb.swagger.generator.core.SwaggerConst;
import org.apache.servicecomb.swagger.generator.core.utils.ClassUtils;
import org.springframework.util.StringUtils;

public class SwaggerToClassGenerator {
    private ClassLoader classLoader;
    private Swagger swagger;
    private String packageName;
    private String interfaceName;
    private Class<?> interfaceCls;
    private TypeFactory typeFactory;
    private ClassPool classPool;
    @VisibleForTesting
    protected Map<Object, JavaType> swaggerObjectMap = new IdentityHashMap<Object, JavaType>();

    public SwaggerToClassGenerator(ClassLoader classLoader, Swagger swagger, String packageName) {
        this.classLoader = classLoader;
        this.swagger = swagger;
        this.packageName = packageName;
        this.typeFactory = TypeFactory.defaultInstance().withClassLoader(classLoader);
        this.classPool = JavassistUtils.getOrCreateClassPool((ClassLoader)classLoader);
    }

    public ClassPool getClassPool() {
        return this.classPool;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Swagger getSwagger() {
        return this.swagger;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public TypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public Class<?> getInterfaceCls() {
        return this.interfaceCls;
    }

    public Class<?> convert() {
        this.collectInterfaceName();
        this.mapDefinitionsToExistingClasses();
        this.convertDefinitions();
        this.convertResponses();
        this.convertPendingCtClasses();
        this.convertToInterface();
        return this.interfaceCls;
    }

    protected void collectInterfaceName() {
        if (this.interfaceName != null) {
            return;
        }
        if (this.swagger.getInfo() != null) {
            this.interfaceName = ClassUtils.getInterfaceName(this.swagger.getInfo().getVendorExtensions());
            if (this.interfaceName != null) {
                return;
            }
        }
        this.interfaceName = this.packageName + ".SchemaInterface";
    }

    protected void mapDefinitionsToExistingClasses() {
        this.interfaceCls = ClassUtils.getClassByName(this.classLoader, this.interfaceName);
        if (this.interfaceCls == null) {
            return;
        }
    }

    protected void convertDefinitions() {
        if (this.swagger.getDefinitions() == null) {
            return;
        }
        for (Map.Entry entry : this.swagger.getDefinitions().entrySet()) {
            this.convertModel((String)entry.getKey(), (Model)entry.getValue());
        }
    }

    protected void convertResponses() {
        if (this.swagger.getPaths() == null) {
            return;
        }
        for (Path path : this.swagger.getPaths().values()) {
            for (Operation operation : path.getOperations()) {
                for (Response response : operation.getResponses().values()) {
                    this.convert(response.getResponseSchema());
                    Map headers = response.getHeaders();
                    if (headers == null) continue;
                    for (Property header : headers.values()) {
                        this.convert(header);
                    }
                }
            }
        }
    }

    protected void convertToInterface() {
        if (this.interfaceCls != null) {
            return;
        }
        ClassConfig classConfig = new ClassConfig();
        classConfig.setClassName(this.interfaceName);
        classConfig.setIntf(true);
        if (this.swagger.getPaths() != null) {
            for (Path path : this.swagger.getPaths().values()) {
                for (Operation operation : path.getOperations()) {
                    Response result = (Response)operation.getResponses().get(SwaggerConst.SUCCESS_KEY);
                    JavaType resultJavaType = this.swaggerObjectMap.get(result.getResponseSchema());
                    MethodConfig methodConfig = new MethodConfig();
                    methodConfig.setName(operation.getOperationId());
                    methodConfig.setResult(resultJavaType);
                    for (Parameter parameter : operation.getParameters()) {
                        String paramName = parameter.getName();
                        paramName = ClassUtils.correctMethodParameterName(paramName);
                        JavaType paramJavaType = ConverterMgr.findJavaType(this, parameter);
                        methodConfig.addParameter(paramName, paramJavaType);
                    }
                    classConfig.addMethod(methodConfig);
                }
            }
        }
        this.interfaceCls = JavassistUtils.createClass((ClassLoader)this.classLoader, (ClassConfig)classConfig);
    }

    protected void convertPendingCtClasses() {
        for (Map.Entry<Object, JavaType> entry : this.swaggerObjectMap.entrySet()) {
            JavaType javaType = entry.getValue();
            if (!CtTypeJavaType.class.isInstance(javaType)) continue;
            CtClass ctClass = ((CtTypeJavaType)javaType).getType().getCtClass();
            Class cls = JavassistUtils.createClass((ClassLoader)this.classLoader, (CtClass)ctClass);
            entry.setValue(this.typeFactory.constructType((Type)cls));
        }
    }

    public JavaType convert(Object swaggerObject) {
        JavaType javaType = this.swaggerObjectMap.get(swaggerObject);
        if (javaType == null) {
            javaType = ConverterMgr.findJavaType(this, swaggerObject);
            this.swaggerObjectMap.put(swaggerObject, javaType);
        }
        return javaType;
    }

    public JavaType forceConvert(Object swaggerObject) {
        this.convert(swaggerObject);
        this.convertPendingCtClasses();
        return this.swaggerObjectMap.get(swaggerObject);
    }

    protected void updateJavaClassInVendor(Map<String, Object> vendorExtensions, String shortClsName) {
        String clsName = ClassUtils.getClassName(vendorExtensions);
        if (StringUtils.isEmpty((Object)clsName)) {
            vendorExtensions.put("x-java-class", this.packageName + "." + shortClsName);
        }
    }

    protected JavaType convertModel(String name, Model model) {
        this.updateJavaClassInVendor(model.getVendorExtensions(), name);
        return this.convert(model);
    }

    public JavaType convertRef(String ref) {
        return this.convertModel(ref, (Model)this.swagger.getDefinitions().get(ref));
    }
}

