/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core;

import com.google.inject.util.Types;
import io.swagger.models.HttpMethod;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.Property;
import io.swagger.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.DefaultValue;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.extend.parameter.ContextParameter;
import org.apache.servicecomb.swagger.generator.core.MethodAnnotationProcessor;
import org.apache.servicecomb.swagger.generator.core.ParameterAnnotationProcessor;
import org.apache.servicecomb.swagger.generator.core.ParameterTypeProcessor;
import org.apache.servicecomb.swagger.generator.core.ResponseTypeProcessor;
import org.apache.servicecomb.swagger.generator.core.SwaggerConst;
import org.apache.servicecomb.swagger.generator.core.SwaggerGenerator;
import org.apache.servicecomb.swagger.generator.core.SwaggerGeneratorContext;
import org.apache.servicecomb.swagger.generator.core.processor.annotation.AnnotationUtils;
import org.apache.servicecomb.swagger.generator.core.utils.ParamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class OperationGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationGenerator.class);
    protected SwaggerGenerator swaggerGenerator;
    protected Swagger swagger;
    protected Operation operation;
    protected Map<String, Property> responseHeaderMap = new HashMap<String, Property>();
    protected Method providerMethod;
    private List<Parameter> methodAnnotationParameters = new ArrayList<Parameter>();
    private List<Parameter> providerParameters = new ArrayList<Parameter>();
    private List<Parameter> swaggerParameters = new ArrayList<Parameter>();
    protected SwaggerGeneratorContext context;
    protected String path;
    protected String httpMethod;

    public OperationGenerator(SwaggerGenerator swaggerGenerator, Method providerMethod) {
        this.swaggerGenerator = swaggerGenerator;
        this.swagger = swaggerGenerator.swagger;
        this.operation = new Operation();
        this.providerMethod = providerMethod;
        this.context = swaggerGenerator.context;
        if (this.swagger.getParameters() != null) {
            this.methodAnnotationParameters.addAll(this.swagger.getParameters().values());
        }
    }

    public void addResponseHeader(String name, Property header) {
        this.responseHeaderMap.put(name, header);
    }

    public List<Parameter> getSwaggerParameters() {
        return this.swaggerParameters;
    }

    public SwaggerGeneratorContext getContext() {
        return this.context;
    }

    public SwaggerGenerator getSwaggerGenerator() {
        return this.swaggerGenerator;
    }

    public Swagger getSwagger() {
        return this.swagger;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        if (!(path = this.context.resolveStringValue(path)).startsWith("/")) {
            path = "/" + path;
        }
        this.path = path;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        if (StringUtils.isEmpty((Object)httpMethod)) {
            return;
        }
        this.httpMethod = httpMethod.toLowerCase(Locale.US);
    }

    public void addMethodAnnotationParameter(Parameter parameter) {
        this.methodAnnotationParameters.add(parameter);
    }

    public void addProviderParameter(Parameter parameter) {
        if (ContextParameter.class.isInstance(parameter)) {
            this.providerParameters.add(parameter);
            return;
        }
        for (Parameter providerParameter : this.providerParameters) {
            if (!parameter.getName().equals(providerParameter.getName())) continue;
            LOGGER.warn("Param name [{}] is duplicated which may cause ambiguous deserialization result. Please check you schema definition", (Object)parameter.getName());
            return;
        }
        this.providerParameters.add(parameter);
    }

    public List<Parameter> getProviderParameters() {
        return this.providerParameters;
    }

    public void generate() {
        this.scanMethodAnnotation();
        this.scanMethodParameters();
        this.scanResponse();
        this.checkBodyParameter();
        this.copyToSwaggerParameters();
        this.operation.setParameters(this.swaggerParameters);
        this.correctOperation();
    }

    protected void copyToSwaggerParameters() {
        for (Parameter parameter : this.providerParameters) {
            if (ContextParameter.class.isInstance(parameter)) continue;
            int annotationIdx = ParamUtils.findParameterByName(parameter.getName(), this.methodAnnotationParameters);
            if (annotationIdx != -1) {
                Parameter annotationParameter = this.methodAnnotationParameters.remove(annotationIdx);
                this.swaggerParameters.add(annotationParameter);
                continue;
            }
            this.swaggerParameters.add(parameter);
        }
        this.swaggerParameters.addAll(this.methodAnnotationParameters);
    }

    protected int countRealBodyParameter(List<Parameter> parameters) {
        int count = 0;
        for (Parameter p : parameters) {
            if (!ParamUtils.isRealBodyParameter(p)) continue;
            ++count;
        }
        return count;
    }

    protected void checkBodyParameter() {
        int annotationBodyCount = this.countRealBodyParameter(this.methodAnnotationParameters);
        if (annotationBodyCount > 1) {
            throw new Error(String.format("too many (%d) body parameter in %s:%s annotation", annotationBodyCount, this.providerMethod.getDeclaringClass().getName(), this.providerMethod.getName()));
        }
        int parameterBodyCount = this.countRealBodyParameter(this.providerParameters);
        if (parameterBodyCount > 1) {
            throw new Error(String.format("too many (%d) body parameter in %s:%s parameters", parameterBodyCount, this.providerMethod.getDeclaringClass().getName(), this.providerMethod.getName()));
        }
        if (annotationBodyCount + parameterBodyCount >= 2) {
            throw new Error(String.format("not allow both defined body parameter in %s:%s annotation and parameters", this.providerMethod.getDeclaringClass().getName(), this.providerMethod.getName()));
        }
    }

    protected void scanMethodAnnotation() {
        for (Annotation annotation : this.providerMethod.getAnnotations()) {
            MethodAnnotationProcessor processor = this.context.findMethodAnnotationProcessor(annotation.annotationType());
            if (processor == null) continue;
            processor.process(annotation, this);
        }
        this.setDefaultTag();
    }

    private void setDefaultTag() {
        if (null != this.operation.getTags()) {
            for (String tag : this.operation.getTags()) {
                if (StringUtils.isEmpty((Object)tag)) continue;
                return;
            }
        }
        if (!this.swaggerGenerator.getDefaultTags().isEmpty()) {
            this.operation.setTags(new ArrayList<String>(this.swaggerGenerator.getDefaultTags()));
        }
    }

    protected void scanMethodParameters() {
        Annotation[][] allAnnotations = this.providerMethod.getParameterAnnotations();
        Type[] parameterTypes = this.providerMethod.getGenericParameterTypes();
        for (int paramIdx = 0; paramIdx < parameterTypes.length; ++paramIdx) {
            int swaggerParamCount = this.providerParameters.size();
            Type type = parameterTypes[paramIdx];
            Annotation[] paramAnnotations = allAnnotations[paramIdx];
            this.processByParameterAnnotation(paramAnnotations, paramIdx, type);
            if (this.isArgumentNotProcessed(swaggerParamCount)) {
                this.processByParameterType(type, paramIdx);
            }
            if (this.isArgumentNotProcessed(swaggerParamCount)) {
                this.context.getDefaultParamProcessor().process(this, paramIdx);
            }
            if (this.isArgumentNotProcessed(swaggerParamCount)) continue;
            Parameter parameter = this.providerParameters.get(this.providerParameters.size() - 1);
            AnnotationUtils.processApiParam(paramAnnotations, parameter);
        }
    }

    private boolean isArgumentNotProcessed(int swaggerParamCount) {
        return swaggerParamCount == this.providerParameters.size();
    }

    protected void processByParameterAnnotation(Annotation[] paramAnnotations, int paramIdx, Type parameterType) {
        String defaultValue = null;
        Parameter parameter = null;
        for (Annotation annotation : paramAnnotations) {
            if (annotation instanceof DefaultValue) {
                defaultValue = ((DefaultValue)annotation).value();
                continue;
            }
            ParameterAnnotationProcessor processor = this.context.findParameterAnnotationProcessor(annotation.annotationType());
            if (processor == null) continue;
            processor.process(annotation, this, paramIdx);
            parameter = this.providerParameters.get(this.providerParameters.size() - 1);
        }
        if (parameter instanceof AbstractSerializableParameter) {
            if (defaultValue != null) {
                ((AbstractSerializableParameter)parameter).setDefaultValue(defaultValue);
            } else if (((AbstractSerializableParameter)parameter).getDefaultValue() == null && !((AbstractSerializableParameter)parameter).getRequired()) {
                if (parameterType instanceof Class && ((Class)parameterType).isPrimitive()) {
                    switch (parameterType.getTypeName()) {
                        case "boolean": {
                            defaultValue = "false";
                            break;
                        }
                        default: {
                            defaultValue = "0";
                        }
                    }
                }
                ((AbstractSerializableParameter)parameter).setDefaultValue(defaultValue);
            }
        }
    }

    protected void processByParameterType(Type parameterType, int paramIdx) {
        Type realType;
        ParameterTypeProcessor processor = this.context.findParameterTypeProcessor(parameterType);
        if (processor == null && (realType = this.checkAndGetType(parameterType)) != null) {
            processor = this.context.findParameterTypeProcessor(realType);
        }
        if (processor != null) {
            processor.process(this, paramIdx);
        }
    }

    private Type checkAndGetType(Type type) {
        ParameterizedType targetType;
        Class targetCls;
        if (ParameterizedType.class.isAssignableFrom(type.getClass()) && List.class.isAssignableFrom(targetCls = (Class)(targetType = (ParameterizedType)type).getRawType())) {
            return Types.newParameterizedType(List.class, (Type[])new Type[]{targetType.getActualTypeArguments()[0]});
        }
        return null;
    }

    public void correctOperation() {
        if (StringUtils.isEmpty((Object)this.operation.getOperationId())) {
            this.operation.setOperationId(this.providerMethod.getName());
        }
        this.context.postProcessOperation(this);
        SwaggerUtils.correctResponses(this.operation);
        this.addHeaderToResponse();
    }

    private void addHeaderToResponse() {
        for (Map.Entry responseEntry : this.operation.getResponses().entrySet()) {
            Response response = (Response)responseEntry.getValue();
            for (Map.Entry<String, Property> entry : this.responseHeaderMap.entrySet()) {
                if (response.getHeaders() != null && response.getHeaders().containsKey(entry.getKey())) continue;
                response.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    public void scanResponse() {
        Response successResponse;
        if (this.operation.getResponses() != null && (successResponse = (Response)this.operation.getResponses().get(SwaggerConst.SUCCESS_KEY)) != null) {
            if (successResponse.getResponseSchema() == null) {
                Model model = this.createResponseModel();
                successResponse.setResponseSchema(model);
            }
            return;
        }
        Model model = this.createResponseModel();
        Response response = new Response();
        response.setResponseSchema(model);
        this.operation.addResponse(SwaggerConst.SUCCESS_KEY, response);
    }

    protected Model createResponseModel() {
        Class<?> responseType = this.providerMethod.getReturnType();
        if (ReflectionUtils.isVoid(responseType)) {
            return null;
        }
        ResponseTypeProcessor processor = this.context.findResponseTypeProcessor(responseType);
        return processor.process(this, ParamUtils.getGenericParameterType(this.getCls(), this.providerMethod.getDeclaringClass(), this.providerMethod.getGenericReturnType()));
    }

    public Method getProviderMethod() {
        return this.providerMethod;
    }

    public Class<?> getCls() {
        return this.swaggerGenerator.getCls();
    }

    protected void addOperationToSwagger() {
        if (StringUtils.isEmpty((Object)this.httpMethod)) {
            return;
        }
        Path pathObj = this.swagger.getPath(this.path);
        if (pathObj == null) {
            pathObj = new Path();
            this.swagger.path(this.path, pathObj);
        }
        HttpMethod hm = HttpMethod.valueOf((String)this.httpMethod.toUpperCase(Locale.US));
        if (pathObj.getOperationMap().get(hm) != null) {
            throw new Error(String.format("Only allowed one default path. %s:%s", this.swaggerGenerator.getCls().getName(), this.providerMethod.getName()));
        }
        pathObj.set(this.httpMethod, this.operation);
    }
}

