/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.metrics.servo;

import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.MonitorRegistry;
import com.netflix.servo.monitor.Monitors;
import org.springframework.boot.actuate.autoconfigure.ExportMetricReader;
import org.springframework.boot.actuate.autoconfigure.MetricRepositoryAutoConfiguration;
import org.springframework.boot.actuate.endpoint.MetricReaderPublicMetrics;
import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.actuate.metrics.GaugeService;
import org.springframework.boot.actuate.metrics.reader.MetricReader;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.netflix.metrics.DefaultMetricsTagProvider;
import org.springframework.cloud.netflix.metrics.MetricsInterceptorConfiguration;
import org.springframework.cloud.netflix.metrics.MetricsTagProvider;
import org.springframework.cloud.netflix.metrics.servo.HierarchicalServoMetricNaming;
import org.springframework.cloud.netflix.metrics.servo.ServoMetricNaming;
import org.springframework.cloud.netflix.metrics.servo.ServoMetricReader;
import org.springframework.cloud.netflix.metrics.servo.ServoMetricServices;
import org.springframework.cloud.netflix.metrics.servo.ServoMetricsConfigBean;
import org.springframework.cloud.netflix.metrics.servo.ServoMonitorCache;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(value={Monitors.class, MetricReader.class})
@ConditionalOnMissingClass(value={"com.netflix.spectator.api.Registry"})
@AutoConfigureBefore(value={MetricRepositoryAutoConfiguration.class})
@Import(value={MetricsInterceptorConfiguration.class})
@ConditionalOnProperty(name={"spring.metrics.servo.enabled"}, matchIfMissing=true)
public class ServoMetricsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ServoMetricsConfigBean servoMetricsConfig() {
        return new ServoMetricsConfigBean();
    }

    @Bean
    @ConditionalOnMissingBean
    public ServoMetricNaming servoMetricNaming() {
        return new HierarchicalServoMetricNaming();
    }

    @Bean
    @ConditionalOnMissingBean
    public MonitorRegistry monitorRegistry(ServoMetricsConfigBean servoMetricsConfig) {
        System.setProperty(DefaultMonitorRegistry.class.getCanonicalName() + ".registryClass", servoMetricsConfig.getRegistryClass());
        return DefaultMonitorRegistry.getInstance();
    }

    @Bean
    public ServoMonitorCache monitorCache(MonitorRegistry monitorRegistry, ServoMetricsConfigBean servoMetricsConfig) {
        return new ServoMonitorCache(monitorRegistry, servoMetricsConfig);
    }

    @Bean
    @ExportMetricReader
    public ServoMetricReader servoMetricReader(MonitorRegistry monitorRegistry, ServoMetricNaming servoMetricNaming) {
        ServoMetricReader reader = new ServoMetricReader(monitorRegistry, servoMetricNaming);
        return reader;
    }

    @Bean
    public MetricReaderPublicMetrics servoPublicMetrics(ServoMetricReader reader) {
        return new MetricReaderPublicMetrics((MetricReader)reader);
    }

    @Bean
    @ConditionalOnMissingBean(value={CounterService.class, GaugeService.class})
    public ServoMetricServices servoMetricServices(MonitorRegistry monitorRegistry) {
        return new ServoMetricServices(monitorRegistry);
    }

    @Configuration
    @ConditionalOnClass(name={"javax.servlet.http.HttpServletRequest"})
    protected static class MetricsTagConfiguration {
        protected MetricsTagConfiguration() {
        }

        @Bean
        public MetricsTagProvider defaultMetricsTagProvider() {
            return new DefaultMetricsTagProvider();
        }
    }
}

