/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.contexts;

import io.reactivex.netty.contexts.RequestCorrelator;
import io.reactivex.netty.contexts.RequestIdProvider;
import io.reactivex.netty.contexts.http.HttpClientContextConfigurator;
import io.reactivex.netty.contexts.http.HttpServerContextConfigurator;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import io.reactivex.netty.pipeline.PipelineConfigurators;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import io.reactivex.netty.protocol.http.server.HttpServerResponse;
import io.reactivex.netty.protocol.http.sse.ServerSentEvent;

public final class ContextPipelineConfigurators {
    private ContextPipelineConfigurators() {
    }

    public static <I, O> PipelineConfigurator<HttpServerRequest<I>, HttpServerResponse<O>> httpServerConfigurator(RequestIdProvider requestIdProvider, RequestCorrelator correlator, PipelineConfigurator<HttpServerRequest<I>, HttpServerResponse<O>> httpConfigurator) {
        return new HttpServerContextConfigurator<I, O>(requestIdProvider, correlator, httpConfigurator);
    }

    public static <I, O> PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> httpClientConfigurator(RequestIdProvider requestIdProvider, RequestCorrelator correlator, PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> httpConfigurator) {
        return new HttpClientContextConfigurator<I, O>(requestIdProvider, correlator, httpConfigurator);
    }

    public static <I, O> PipelineConfigurator<HttpServerRequest<I>, HttpServerResponse<O>> httpServerConfigurator(RequestIdProvider requestIdProvider, RequestCorrelator correlator) {
        return ContextPipelineConfigurators.httpServerConfigurator(requestIdProvider, correlator, PipelineConfigurators.httpServerConfigurator());
    }

    public static <I, O> PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> httpClientConfigurator(RequestIdProvider requestIdProvider, RequestCorrelator correlator) {
        return ContextPipelineConfigurators.httpClientConfigurator(requestIdProvider, correlator, PipelineConfigurators.httpClientConfigurator());
    }

    public static <I> PipelineConfigurator<HttpClientResponse<ServerSentEvent>, HttpClientRequest<I>> sseClientConfigurator(RequestIdProvider requestIdProvider, RequestCorrelator correlator) {
        return new HttpClientContextConfigurator(requestIdProvider, correlator, PipelineConfigurators.clientSseConfigurator());
    }

    public static <I> PipelineConfigurator<HttpServerRequest<I>, HttpServerResponse<ServerSentEvent>> sseServerConfigurator(RequestIdProvider requestIdProvider, RequestCorrelator correlator) {
        return new HttpServerContextConfigurator(requestIdProvider, correlator, PipelineConfigurators.serveSseConfigurator());
    }
}

