/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.javassist;

import com.fasterxml.jackson.databind.JavaType;
import java.util.ArrayList;
import java.util.List;
import org.apache.servicecomb.common.javassist.CtType;
import org.apache.servicecomb.common.javassist.ParameterConfig;

public class MethodConfig {
    private String name;
    private CtType result;
    private List<ParameterConfig> parameterList = new ArrayList<ParameterConfig>();
    private String bodySource;
    private String source;
    private String genericSignature;

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getGenericSignature() {
        return this.genericSignature;
    }

    public void setGenericSignature(String genericSignature) {
        this.genericSignature = genericSignature;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setResult(JavaType javaType) {
        this.result = new CtType(javaType);
    }

    public void setResult(CtType result) {
        this.result = result;
    }

    public void addParameter(String name, JavaType javaType) {
        this.addParameter(name, new CtType(javaType));
    }

    public void addParameter(String name, CtType ctType) {
        ParameterConfig parameterConfig = new ParameterConfig();
        parameterConfig.setName(name);
        parameterConfig.setType(ctType);
        this.parameterList.add(parameterConfig);
    }

    public void setBodySource(String bodySource) {
        this.bodySource = bodySource;
    }

    void init() {
        if (this.source != null) {
            return;
        }
        StringBuilder sbMethod = new StringBuilder();
        StringBuilder sbMethodGenericSignature = new StringBuilder();
        sbMethod.append("public ");
        sbMethod.append(this.result == null ? "void" : this.result.getCtClass().getName());
        sbMethod.append(" ").append(this.name).append("(");
        sbMethodGenericSignature.append("(");
        boolean hasGenericSignature = this.result != null && this.result.hasGenericTypes();
        for (ParameterConfig parameter : this.parameterList) {
            hasGenericSignature = hasGenericSignature || parameter.getType().hasGenericTypes();
            String paramTypeName = parameter.getType().getCtClass().getName();
            String code = String.format("%s %s,", paramTypeName, parameter.getName());
            sbMethod.append(code);
            sbMethodGenericSignature.append(parameter.getType().getGenericSignature());
        }
        if (!this.parameterList.isEmpty()) {
            sbMethod.setLength(sbMethod.length() - 1);
        }
        sbMethod.append(")");
        sbMethodGenericSignature.append(")");
        sbMethodGenericSignature.append(this.result == null ? "V" : this.result.getGenericSignature());
        if (this.bodySource != null) {
            sbMethod.append("{").append(this.bodySource).append("}");
        } else {
            sbMethod.append(";");
        }
        this.source = sbMethod.toString();
        if (hasGenericSignature) {
            this.genericSignature = sbMethodGenericSignature.toString();
        }
    }
}

