/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core;

import com.netflix.config.DynamicPropertyFactory;
import javax.inject.Inject;
import org.apache.servicecomb.core.BootListener;
import org.apache.servicecomb.core.definition.schema.ProducerSchemaFactory;
import org.apache.servicecomb.metrics.core.publish.HealthCheckerRestPublisher;
import org.springframework.stereotype.Component;

@Component
public class HealthBootListener
implements BootListener {
    @Inject
    ProducerSchemaFactory producerSchemaFactory;

    public void onBootEvent(BootListener.BootEvent event) {
        if (event.getEventType() == BootListener.EventType.BEFORE_PRODUCER_PROVIDER) {
            this.registerSchemas();
        }
    }

    private void registerSchemas() {
        if (!DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.health.endpoint.enabled", true).get()) {
            return;
        }
        this.producerSchemaFactory.getOrCreateProducerSchema("healthEndpoint", HealthCheckerRestPublisher.class, (Object)new HealthCheckerRestPublisher());
    }
}

