/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.dispatch;

import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import reactor.Environment;
import reactor.core.Dispatcher;
import reactor.fn.Consumer;

public final class TailRecurseDispatcher
implements Dispatcher {
    public static final TailRecurseDispatcher INSTANCE = new TailRecurseDispatcher();
    private final PriorityBlockingQueue<Task> queue = new PriorityBlockingQueue();
    private final AtomicInteger wip = new AtomicInteger();
    private static final AtomicIntegerFieldUpdater<TailRecurseDispatcher> COUNTER_UPDATER = AtomicIntegerFieldUpdater.newUpdater(TailRecurseDispatcher.class, "counter");
    private volatile boolean terminated = false;
    private volatile int counter;

    @Override
    public boolean alive() {
        return this.terminated;
    }

    @Override
    public boolean awaitAndShutdown() {
        this.terminated = true;
        return true;
    }

    @Override
    public boolean awaitAndShutdown(long timeout, TimeUnit timeUnit) {
        this.terminated = true;
        return true;
    }

    @Override
    public void shutdown() {
        this.awaitAndShutdown();
    }

    @Override
    public void forceShutdown() {
        this.awaitAndShutdown();
    }

    @Override
    public <E> void tryDispatch(E event, Consumer<E> consumer, Consumer<Throwable> errorConsumer) {
        this.dispatch(event, consumer, errorConsumer);
    }

    @Override
    public <E> void dispatch(E event, Consumer<E> eventConsumer, Consumer<Throwable> errorConsumer) {
        if (this.terminated) {
            return;
        }
        Task task = new Task(COUNTER_UPDATER.incrementAndGet(this), event, eventConsumer, errorConsumer);
        this.queue.add(task);
        if (this.wip.getAndIncrement() == 0) {
            do {
                Task polled;
                if ((polled = this.queue.poll()) == null) continue;
                try {
                    polled.eventConsumer.accept(polled.data);
                }
                catch (Throwable e) {
                    if (polled.errorConsumer != null) {
                        polled.errorConsumer.accept(e);
                        continue;
                    }
                    if (!Environment.alive()) continue;
                    Environment.get().routeError(e);
                }
            } while (this.wip.decrementAndGet() > 0);
        }
    }

    @Override
    public void execute(final Runnable command) {
        this.dispatch(null, new Consumer<Void>(){

            @Override
            public void accept(Void aVoid) {
                command.run();
            }
        }, null);
    }

    @Override
    public long remainingSlots() {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean supportsOrdering() {
        return true;
    }

    @Override
    public long backlogSize() {
        return this.counter;
    }

    @Override
    public boolean inContext() {
        return true;
    }

    public String toString() {
        return this.counter + ", " + this.queue.toString();
    }

    private static class Task
    implements Comparable<Task> {
        final Object data;
        final Consumer eventConsumer;
        final Consumer<Throwable> errorConsumer;
        final int index;

        public Task(int index, Object data, Consumer eventConsumer, Consumer<Throwable> errorConsumer) {
            this.data = data;
            this.index = index;
            this.eventConsumer = eventConsumer;
            this.errorConsumer = errorConsumer;
        }

        @Override
        public int compareTo(Task o) {
            return Integer.compare(this.index, o.index);
        }
    }
}

