/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.vertx.ws;

import com.google.common.eventbus.EventBus;
import com.netflix.config.DynamicPropertyFactory;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.WebSocketBase;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.event.WebSocketActionEvent;
import org.apache.servicecomb.core.executor.ReactiveExecutor;
import org.apache.servicecomb.core.tracing.BraveTraceIdGenerator;
import org.apache.servicecomb.core.tracing.TraceIdGenerator;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.swagger.invocation.InvocationType;
import org.apache.servicecomb.swagger.invocation.ws.AbstractBaseWebSocket;
import org.apache.servicecomb.swagger.invocation.ws.BinaryBytesWebSocketMessage;
import org.apache.servicecomb.swagger.invocation.ws.SerialExecutorWrapper;
import org.apache.servicecomb.swagger.invocation.ws.TextWebSocketMessage;
import org.apache.servicecomb.swagger.invocation.ws.WebSocketActionType;
import org.apache.servicecomb.swagger.invocation.ws.WebSocketAdapter;
import org.apache.servicecomb.swagger.invocation.ws.WebSocketFrame;
import org.apache.servicecomb.swagger.invocation.ws.WebSocketMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxWebSocketAdaptor
implements WebSocketAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertxWebSocketAdaptor.class);
    private static final TraceIdGenerator CONNECTION_ID_GENERATOR = new BraveTraceIdGenerator();
    private static final int DEFAULT_ADAPTER_QUEUE_MAX_SIZE = 100;
    private static final int DEFAULT_ADAPTER_QUEUE_MAX_CONTINUE_TIMES = 10;
    private final Executor executor;
    private final AbstractBaseWebSocket bizWebSocket;
    private final WebSocketBase vertxWebSocket;
    private final Object pauseLock = new Object();
    private final Invocation invocation;
    private final long creationTimestamp;
    private final EventBus eventBus;
    private boolean inPauseStatus;
    private final String connectionId;
    private final InvocationType invocationType;

    public VertxWebSocketAdaptor(Invocation invocation, InvocationType invocationType, Executor workerPool, AbstractBaseWebSocket bizWebSocket, WebSocketBase vertxWebSocket) {
        Objects.requireNonNull(invocation, "VertxWebSocketAdaptor invocation is null");
        Objects.requireNonNull(workerPool, "VertxWebSocketAdaptor workerPool is null");
        Objects.requireNonNull(bizWebSocket, "VertxWebSocketAdaptor bizWebSocket is null");
        Objects.requireNonNull(vertxWebSocket, "VertxWebSocketAdaptor vertxWebSocket is null");
        this.creationTimestamp = System.currentTimeMillis();
        this.invocation = invocation;
        this.invocationType = invocationType;
        this.connectionId = CONNECTION_ID_GENERATOR.generate();
        this.executor = workerPool instanceof ReactiveExecutor ? workerPool : this.prepareSerialExecutorWrapper(workerPool);
        this.bizWebSocket = bizWebSocket;
        this.vertxWebSocket = vertxWebSocket;
        this.eventBus = EventManager.getEventBus();
        this.inPauseStatus = true;
        vertxWebSocket.pause();
        this.linkVertxToBiz();
        this.linkBizToVertx(bizWebSocket);
        this.startWorking();
    }

    private void linkBizToVertx(AbstractBaseWebSocket bizWebSocket) {
        bizWebSocket.setWebSocketAdapter((WebSocketAdapter)this);
    }

    private SerialExecutorWrapper prepareSerialExecutorWrapper(Executor workerPool) {
        SerialExecutorWrapper wrapper = new SerialExecutorWrapper(this.invocationType, this.connectionId, workerPool, DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.websocket.adapter.queue.maxSize", 100).get(), DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.websocket.adapter.queue.maxContinueTimes", 10).get());
        wrapper.subscribeQueueDrainEvent(this::resume);
        wrapper.subscribeQueueFullEvent(this::pause);
        return wrapper;
    }

    private void linkVertxToBiz() {
        this.linkVertxDrainHandler();
        this.linkVertxTextMessageHandler();
        this.linkVertxBinaryMessageHandler();
        this.linkVertxFrameHandler();
        this.linkVertxExceptionHandler();
        this.linkVertxCloseHandler();
    }

    private void linkVertxCloseHandler() {
        this.vertxWebSocket.closeHandler(v -> this.scheduleTask(this.createWebSocketActionEvent(WebSocketActionType.ON_CLOSE), () -> this.bizWebSocket.onClose(this.vertxWebSocket.closeStatusCode(), this.vertxWebSocket.closeReason())));
    }

    private void linkVertxExceptionHandler() {
        this.vertxWebSocket.exceptionHandler(t -> this.scheduleTask(this.createWebSocketActionEvent(WebSocketActionType.ON_ERROR), () -> this.bizWebSocket.onError(t)));
    }

    private void linkVertxFrameHandler() {
    }

    private void linkVertxBinaryMessageHandler() {
        this.vertxWebSocket.binaryMessageHandler(buffer -> {
            byte[] bytes = buffer.getBytes();
            this.scheduleTask(this.createWebSocketActionEvent(WebSocketActionType.ON_MESSAGE_BINARY).setDataSize((long)buffer.length()), () -> this.bizWebSocket.onMessage((WebSocketMessage)new BinaryBytesWebSocketMessage(bytes)));
        });
    }

    private void linkVertxTextMessageHandler() {
        this.vertxWebSocket.textMessageHandler(s -> this.scheduleTask(this.createWebSocketActionEvent(WebSocketActionType.ON_MESSAGE_TEXT).setDataSize((long)s.length()), () -> this.bizWebSocket.onMessage((WebSocketMessage)new TextWebSocketMessage(s))));
    }

    private void linkVertxDrainHandler() {
        this.vertxWebSocket.drainHandler(v -> this.scheduleTask(this.createWebSocketActionEvent(WebSocketActionType.ON_SEND_QUEUE_DRAIN), () -> ((AbstractBaseWebSocket)this.bizWebSocket).onWriteQueueDrain()));
    }

    private void startWorking() {
        WebSocketActionEvent event = this.createWebSocketActionEventInSyncMode(WebSocketActionType.CONNECTION_PREPARE);
        this.scheduleTask(this.createWebSocketActionEvent(WebSocketActionType.ON_OPEN), () -> ((AbstractBaseWebSocket)this.bizWebSocket).startWorking());
        this.eventBus.post((Object)event.setActionEndTimestamp(System.currentTimeMillis()));
    }

    private WebSocketActionEvent createWebSocketActionEvent(WebSocketActionType actionType) {
        return new WebSocketActionEvent().setActionType(actionType).setConnectionStartTimestamp(this.creationTimestamp).setInvocationType(this.invocationType).setHandleThreadName(Thread.currentThread().getName()).setOperationMeta(this.invocation.getOperationMeta()).setConnectionId(this.connectionId).setTraceId(this.invocation.getTraceId()).setScheduleStartTimestamp(System.currentTimeMillis());
    }

    private WebSocketActionEvent createWebSocketActionEventInSyncMode(WebSocketActionType actionType) {
        return this.createWebSocketActionEvent(actionType).setActionStartTimestamp(System.currentTimeMillis()).setHandleThreadName(Thread.currentThread().getName());
    }

    private void scheduleTask(WebSocketActionEvent event, Runnable task) {
        try {
            this.executor.execute(() -> {
                event.setActionStartTimestamp(System.currentTimeMillis()).setHandleThreadName(Thread.currentThread().getName());
                try {
                    task.run();
                }
                catch (Throwable e) {
                    LOGGER.error("[{}]-[{}] error occurs while executing task, actionType is {}", new Object[]{this.invocationType, this.connectionId, event.getActionType()});
                }
                finally {
                    this.eventBus.post((Object)event.setActionEndTimestamp(System.currentTimeMillis()));
                }
            });
        }
        catch (Throwable e) {
            LOGGER.error("[{}]-[{}] error occurs in scheduleTask", new Object[]{this.invocationType, this.connectionId, e});
        }
    }

    public CompletableFuture<Void> sendMessage(WebSocketMessage<?> message) {
        if (message instanceof TextWebSocketMessage) {
            String payload = (String)((TextWebSocketMessage)message).getPayload();
            return this.decorateSenderAction(WebSocketActionType.DO_SEND_TEXT, payload.length(), this.vertxWebSocket.writeTextMessage(payload).toCompletionStage().toCompletableFuture());
        }
        if (message instanceof BinaryBytesWebSocketMessage) {
            byte[] payload = (byte[])((BinaryBytesWebSocketMessage)message).getPayload();
            return this.decorateSenderAction(WebSocketActionType.DO_SEND_BINARY, payload.length, this.vertxWebSocket.writeBinaryMessage(Buffer.buffer((byte[])payload)).toCompletionStage().toCompletableFuture());
        }
        throw new IllegalStateException("impossible case, unrecognized WebSocketMessage type!");
    }

    public CompletableFuture<Void> sendFrame(WebSocketFrame frame) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> close(short statusCode, String reason) {
        return this.decorateSenderAction(WebSocketActionType.DO_CLOSE, 0, this.vertxWebSocket.close(statusCode, reason).toCompletionStage().toCompletableFuture());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        WebSocketActionEvent event = this.createWebSocketActionEventInSyncMode(WebSocketActionType.DO_PAUSE);
        Object object = this.pauseLock;
        synchronized (object) {
            if (this.inPauseStatus) {
                return;
            }
            this.vertxWebSocket.pause();
            this.inPauseStatus = true;
            LOGGER.info("[{}]-[{}] pause websocket", (Object)this.invocationType, (Object)this.connectionId);
        }
        this.eventBus.post((Object)event.setActionEndTimestamp(System.currentTimeMillis()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        WebSocketActionEvent event = this.createWebSocketActionEventInSyncMode(WebSocketActionType.DO_RESUME);
        Object object = this.pauseLock;
        synchronized (object) {
            if (!this.inPauseStatus) {
                return;
            }
            this.vertxWebSocket.resume();
            this.inPauseStatus = false;
            LOGGER.info("[{}]-[{}] resume websocket", (Object)this.invocationType, (Object)this.connectionId);
        }
        this.eventBus.post((Object)event.setActionEndTimestamp(System.currentTimeMillis()));
    }

    public boolean writeQueueFull() {
        return this.vertxWebSocket.writeQueueFull();
    }

    private <T> CompletableFuture<T> decorateSenderAction(WebSocketActionType actionType, int dataSize, CompletableFuture<T> actionFuture) {
        WebSocketActionEvent event = this.createWebSocketActionEventInSyncMode(actionType).setDataSize((long)dataSize);
        actionFuture.whenComplete((v, t) -> this.eventBus.post((Object)event.setActionEndTimestamp(System.currentTimeMillis())));
        return actionFuture;
    }
}

