/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.loadbalance.RoundRobinRuleExt;
import org.apache.servicecomb.loadbalance.ServiceCombServer;

public class WeightedResponseTimeRuleExt
extends RoundRobinRuleExt {
    private static final double MIN_GAP = 10.0;
    private static final int RANDOM_PERCENT = 1000;
    private final Object lock = new Object();
    private final AtomicInteger counter = new AtomicInteger(0);
    private volatile int size = -1;
    private volatile List<Double> cacheStates = new ArrayList<Double>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceCombServer choose(List<ServiceCombServer> servers, Invocation invocation) {
        List<Double> stats;
        int count = this.counter.getAndIncrement();
        if (count % 1000 == 0 || this.size != servers.size()) {
            Object object = this.lock;
            synchronized (object) {
                this.cacheStates = WeightedResponseTimeRuleExt.doCalculateTotalWeights(servers);
                this.size = servers.size();
            }
        }
        if ((stats = this.cacheStates).size() > 0) {
            double finalTotal = stats.get(stats.size() - 1);
            ArrayList<Double> weights = new ArrayList<Double>(servers.size());
            for (int i = 0; i < stats.size() - 1; ++i) {
                weights.add(finalTotal - stats.get(i));
            }
            double ran = ThreadLocalRandom.current().nextDouble() * finalTotal * (double)(servers.size() - 1);
            for (int i = 0; i < weights.size(); ++i) {
                if (!((ran -= ((Double)weights.get(i)).doubleValue()) < 0.0)) continue;
                return servers.get(i);
            }
            return servers.get(servers.size() - 1);
        }
        return super.choose(servers, invocation);
    }

    private static List<Double> doCalculateTotalWeights(List<ServiceCombServer> servers) {
        ArrayList<Double> stats = new ArrayList<Double>(servers.size() + 1);
        double totalWeights = 0.0;
        boolean needRandom = false;
        for (ServiceCombServer server : servers) {
            double avgTime = server.getServerMetrics().getSnapshot().getAverageDuration().toMillis();
            if (!needRandom && avgTime > 10.0) {
                needRandom = true;
            }
            totalWeights += avgTime;
            stats.add(avgTime);
        }
        stats.add(totalWeights);
        if (needRandom) {
            return stats;
        }
        return new ArrayList<Double>();
    }
}

