/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest;

import org.apache.servicecomb.common.rest.codec.produce.ProduceProcessor;
import org.apache.servicecomb.common.rest.codec.produce.ProduceProcessorManager;
import org.apache.servicecomb.common.rest.filter.inner.RestServerCodecFilter;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.exception.Exceptions;
import org.apache.servicecomb.core.invocation.InvocationCreator;
import org.apache.servicecomb.core.invocation.ProducerInvocationFlow;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.swagger.invocation.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestProducerInvocationFlow
extends ProducerInvocationFlow {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestProducerInvocationFlow.class);
    private static final ProduceProcessor DEFAULT_PRODUCE_PROCESSOR = ProduceProcessorManager.INSTANCE.findDefaultProcessor();

    public RestProducerInvocationFlow(InvocationCreator invocationCreator, HttpServletRequestEx requestEx, HttpServletResponseEx responseEx) {
        super(invocationCreator, requestEx, responseEx);
    }

    protected Invocation sendCreateInvocationException(Throwable throwable) {
        try {
            Response response = Exceptions.toProducerResponse(null, (Throwable)throwable);
            RestServerCodecFilter.encodeResponse(null, response, DEFAULT_PRODUCE_PROCESSOR, this.responseEx);
        }
        catch (Throwable e) {
            LOGGER.error("Failed to send response when prepare invocation failed, request uri:{}", (Object)this.requestEx.getRequestURI(), (Object)e);
        }
        this.endResponse(null);
        return null;
    }

    protected void endResponse(Invocation invocation, Response response) {
        invocation.getInvocationStageTrace().startProviderSendResponse();
        this.endResponse(invocation);
    }

    private void endResponse(Invocation invocation) {
        try {
            this.responseEx.endResponse();
        }
        catch (Throwable flushException) {
            LOGGER.error("Failed to flush rest response, operation:{}, request uri:{}", new Object[]{invocation == null ? "NA" : invocation.getMicroserviceQualifiedName(), this.requestEx.getRequestURI(), flushException});
        }
        try {
            this.requestEx.getAsyncContext().complete();
        }
        catch (Throwable completeException) {
            LOGGER.error("Failed to complete async rest response, operation:{}, request uri:{}", new Object[]{invocation == null ? "NA" : invocation.getMicroserviceQualifiedName(), this.requestEx.getRequestURI(), completeException});
        }
        if (invocation != null) {
            invocation.getInvocationStageTrace().finishProviderSendResponse();
        }
    }
}

