/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.filter.inner;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ServerWebSocket;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.common.rest.WebSocketTransportContext;
import org.apache.servicecomb.common.rest.codec.produce.ProduceJsonProcessor;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.exception.Exceptions;
import org.apache.servicecomb.core.filter.AbstractFilter;
import org.apache.servicecomb.core.filter.EdgeFilter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.core.filter.ProviderFilter;
import org.apache.servicecomb.foundation.vertx.stream.BufferOutputStream;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.context.TransportContext;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketServerCodecFilter
extends AbstractFilter
implements ProviderFilter,
EdgeFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketServerCodecFilter.class);
    public static final String NAME = "websocket-codec";

    public String getName() {
        return NAME;
    }

    public int getOrder() {
        return -2000;
    }

    public boolean enabledForTransport(String transport) {
        return "websocket".equals(transport);
    }

    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(invocation).thenCompose(this::decodeRequest)).thenCompose(v -> this.invokeNext(invocation, nextNode))).exceptionally(exception -> Exceptions.toProducerResponse((Invocation)invocation, (Throwable)exception))).thenCompose(response -> this.encodeResponse(invocation, (Response)response));
    }

    protected CompletableFuture<Response> invokeNext(Invocation invocation, FilterNode nextNode) {
        if (invocation.isEdge()) {
            TransportContext transportContext = invocation.getTransportContext();
            return nextNode.onFilter(invocation).whenComplete((r, e) -> invocation.setTransportContext(transportContext));
        }
        return nextNode.onFilter(invocation);
    }

    protected CompletableFuture<Void> decodeRequest(Invocation invocation) {
        invocation.getInvocationStageTrace().startProviderDecodeRequest();
        invocation.setSwaggerArguments(new HashMap());
        invocation.getInvocationStageTrace().finishProviderDecodeRequest();
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Response> encodeResponse(Invocation invocation, Response response) {
        invocation.onEncodeResponseStart(response);
        WebSocketTransportContext context = (WebSocketTransportContext)invocation.getTransportContext();
        return WebSocketServerCodecFilter.encodeResponse(response, context.getServerWebSocket()).whenComplete((r, e) -> invocation.onEncodeResponseFinish());
    }

    private static boolean isFailedResponse(Response response) {
        return response.getResult() instanceof InvocationException;
    }

    private static CompletableFuture<Response> writeResponse(ServerWebSocket webSocket, Object data, Response response) {
        CompletableFuture<Response> completableFuture;
        BufferOutputStream output = new BufferOutputStream(Buffer.buffer());
        try {
            ProduceJsonProcessor produceProcessor = new ProduceJsonProcessor();
            produceProcessor.encodeResponse((OutputStream)output, data);
            CompletableFuture<Response> result = new CompletableFuture<Response>();
            webSocket.write((Object)output.getBuffer()).onComplete(v -> result.complete(response), result::completeExceptionally);
            completableFuture = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                LOGGER.error("internal service error must be fixed.", e);
                return CompletableFuture.failedFuture(e);
            }
        }
        output.close();
        return completableFuture;
    }

    public static CompletableFuture<Response> encodeResponse(Response response, ServerWebSocket webSocket) {
        if (WebSocketServerCodecFilter.isFailedResponse(response)) {
            return WebSocketServerCodecFilter.writeResponse(webSocket, ((InvocationException)response.getResult()).getErrorData(), response);
        }
        return CompletableFuture.completedFuture(response);
    }
}

