/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.lightweight.model;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.BootStrapProperties;
import org.apache.servicecomb.foundation.common.Version;
import org.apache.servicecomb.registry.lightweight.model.Microservice;
import org.apache.servicecomb.registry.lightweight.model.MicroserviceInstance;
import org.apache.servicecomb.registry.lightweight.model.MicroservicePropertiesLoader;
import org.springframework.core.env.Environment;

public class MicroserviceFactory {
    public Microservice create(Environment environment) {
        Microservice microservice = this.createMicroserviceFromConfiguration(environment);
        microservice.setInstance(MicroserviceInstance.createFromDefinition(environment));
        return microservice;
    }

    private Microservice createMicroserviceFromConfiguration(Environment environment) {
        Microservice microservice = new Microservice();
        if (!StringUtils.isEmpty((CharSequence)environment.getProperty("APP_MAPPING")) && !StringUtils.isEmpty((CharSequence)environment.getProperty(environment.getProperty("APP_MAPPING")))) {
            microservice.setAppId(environment.getProperty(environment.getProperty("APP_MAPPING")));
        } else {
            microservice.setAppId(BootStrapProperties.readApplication((Environment)environment));
        }
        if (!StringUtils.isEmpty((CharSequence)environment.getProperty("SERVICE_MAPPING")) && !StringUtils.isEmpty((CharSequence)environment.getProperty(environment.getProperty("SERVICE_MAPPING")))) {
            microservice.setServiceName(environment.getProperty(environment.getProperty("SERVICE_MAPPING")));
        } else {
            microservice.setServiceName(BootStrapProperties.readServiceName((Environment)environment));
        }
        String version = !StringUtils.isEmpty((CharSequence)environment.getProperty("VERSION_MAPPING")) && !StringUtils.isEmpty((CharSequence)environment.getProperty(environment.getProperty("VERSION_MAPPING"))) ? environment.getProperty(environment.getProperty("VERSION_MAPPING")) : BootStrapProperties.readServiceVersion((Environment)environment);
        new Version(version);
        microservice.setVersion(version);
        microservice.setDescription(BootStrapProperties.readServiceDescription((Environment)environment));
        microservice.setLevel(BootStrapProperties.readServiceRole((Environment)environment));
        Map<String, String> propertiesMap = MicroservicePropertiesLoader.INSTANCE.loadProperties(environment);
        microservice.setProperties(propertiesMap);
        microservice.setEnvironment(BootStrapProperties.readServiceEnvironment((Environment)environment));
        if (microservice.allowCrossApp()) {
            microservice.setAlias(Microservice.generateAbsoluteMicroserviceName(microservice.getAppId(), microservice.getServiceName()));
        }
        microservice.setRegisterBy("SDK");
        return microservice;
    }
}

