/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core;

import com.google.common.eventbus.EventBus;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import org.apache.servicecomb.foundation.metrics.MetricsBootstrapConfig;
import org.apache.servicecomb.foundation.metrics.MetricsInitializer;
import org.apache.servicecomb.foundation.metrics.meter.PeriodMeter;
import org.apache.servicecomb.foundation.vertx.SharedVertxFactory;
import org.apache.servicecomb.metrics.core.meter.vertx.HttpClientEndpointsMeter;
import org.apache.servicecomb.metrics.core.meter.vertx.ServerEndpointsMeter;
import org.springframework.core.env.Environment;

public class VertxMetersInitializer
implements MetricsInitializer,
PeriodMeter {
    public static final String VERTX_ENDPOINTS = "servicecomb.vertx.endpoints";
    public static final String ENDPOINTS_TYPE = "type";
    public static final String ENDPOINTS_CLIENT = "client";
    public static final String ENDPOINTS_SERVER = "server";
    private HttpClientEndpointsMeter httpClientEndpointsMeter;
    private ServerEndpointsMeter serverEndpointsMeter;

    public void init(MeterRegistry meterRegistry, EventBus eventBus, MetricsBootstrapConfig config) {
        this.httpClientEndpointsMeter = new HttpClientEndpointsMeter(meterRegistry, VERTX_ENDPOINTS, Tags.of((String)ENDPOINTS_TYPE, (String)ENDPOINTS_CLIENT), SharedVertxFactory.getMetricsFactory((Environment)config.getEnvironment()).getVertxMetrics().getClientEndpointMetricManager());
        this.serverEndpointsMeter = new ServerEndpointsMeter(meterRegistry, VERTX_ENDPOINTS, Tags.of((String)ENDPOINTS_TYPE, (String)ENDPOINTS_SERVER), SharedVertxFactory.getMetricsFactory((Environment)config.getEnvironment()).getVertxMetrics().getServerEndpointMetricMap());
    }

    public void poll(long msNow, long secondInterval) {
        this.httpClientEndpointsMeter.poll(msNow, secondInterval);
        this.serverEndpointsMeter.poll(msNow, secondInterval);
    }
}

