/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.zeroconfig.multicast;

import com.google.common.net.HostAndPort;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.registry.lightweight.Message;
import org.apache.servicecomb.registry.lightweight.MessageType;
import org.apache.servicecomb.zeroconfig.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Multicast {
    private static final Logger LOGGER = LoggerFactory.getLogger(Multicast.class);
    private final InetSocketAddress bindAddress;
    private final InetAddress group;
    private final MulticastSocket multicastSocket;
    private final byte[] recvBuffer = new byte[1024];
    private final DatagramPacket recvPacket = new DatagramPacket(this.recvBuffer, this.recvBuffer.length);

    public Multicast(Config config) throws IOException {
        this.bindAddress = this.initBindAddress(config);
        this.group = this.initGroup(config);
        LOGGER.info("zero config, address: {}", (Object)this.bindAddress);
        LOGGER.info("zero config, group: {}", (Object)this.group);
        this.multicastSocket = new MulticastSocket(this.bindAddress);
        this.multicastSocket.joinGroup(this.group);
        this.multicastSocket.setSoTimeout((int)TimeUnit.SECONDS.toMillis(5L));
    }

    public Multicast setSendBufferSize(int size) throws SocketException {
        this.multicastSocket.setSendBufferSize(size);
        return this;
    }

    public Multicast setReceiveBufferSize(int size) throws SocketException {
        this.multicastSocket.setReceiveBufferSize(size);
        return this;
    }

    private InetSocketAddress initBindAddress(Config config) {
        HostAndPort hostAndPort = HostAndPort.fromString((String)config.getMulticastAddress());
        return new InetSocketAddress(hostAndPort.getHost(), hostAndPort.getPort());
    }

    private InetAddress initGroup(Config config) throws UnknownHostException {
        return InetAddress.getByName(config.getMulticastGroup());
    }

    public <T> void send(MessageType type, T body) throws IOException {
        byte[] buffer = Message.of((MessageType)type, body).encode();
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length, this.group, this.bindAddress.getPort());
        this.multicastSocket.send(packet);
    }

    public Message<?> recv() throws IOException {
        this.multicastSocket.receive(this.recvPacket);
        return Message.decode((byte[])this.recvPacket.getData(), (int)this.recvPacket.getLength());
    }
}

