/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.inject;

import java.util.Collections;
import org.apache.servicecomb.config.inject.InjectProperties;
import org.apache.servicecomb.config.priority.PriorityPropertyManager;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class InjectBeanPostProcessor
implements BeanPostProcessor {
    private final PriorityPropertyManager priorityPropertyManager;

    public InjectBeanPostProcessor(PriorityPropertyManager priorityPropertyManager) {
        this.priorityPropertyManager = priorityPropertyManager;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class beanCls = BeanUtils.getImplClassFromBean((Object)bean);
        InjectProperties injectProperties = beanCls.getAnnotation(InjectProperties.class);
        if (injectProperties == null) {
            return bean;
        }
        this.priorityPropertyManager.createConfigObject(bean, Collections.emptyMap());
        return bean;
    }
}

