/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.priority;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import org.apache.servicecomb.config.priority.DynamicProperty;
import org.apache.servicecomb.config.priority.PriorityPropertyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public final class PriorityProperty<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PriorityProperty.class);
    private final PriorityPropertyType<T> propertyType;
    private final String joinedPriorityKeys;
    private final Function<DynamicProperty, T> internalValueReader;
    private final DynamicProperty[] properties;
    private T finalValue;

    public PriorityProperty(Environment environment, PriorityPropertyType<T> propertyType) {
        this.propertyType = propertyType;
        this.joinedPriorityKeys = Arrays.toString(propertyType.getPriorityKeys());
        this.internalValueReader = this.collectReader(propertyType.getType());
        this.properties = this.createProperties(environment, propertyType.getPriorityKeys());
        this.initValue();
    }

    private DynamicProperty[] createProperties(Environment environment, String[] priorityKeys) {
        DynamicProperty[] properties = new DynamicProperty[priorityKeys.length];
        for (int idx = 0; idx < priorityKeys.length; ++idx) {
            String key = priorityKeys[idx].trim();
            properties[idx] = new DynamicProperty(environment, key);
        }
        return properties;
    }

    private Function<DynamicProperty, T> collectReader(Type type) {
        if (type == Integer.TYPE || type == Integer.class) {
            return this::readInt;
        }
        if (type == Long.TYPE || type == Long.class) {
            return this::readLong;
        }
        if (type == String.class) {
            return this::readString;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return this::readBoolean;
        }
        if (type == Double.TYPE || type == Double.class) {
            return this::readDouble;
        }
        if (type == Float.TYPE || type == Float.class) {
            return this::readFloat;
        }
        throw new IllegalStateException("not support, type=" + type.getTypeName());
    }

    private T readInt(DynamicProperty property) {
        return (T)property.getInteger();
    }

    private T readLong(DynamicProperty property) {
        return (T)property.getLong();
    }

    private T readString(DynamicProperty property) {
        return (T)property.getString();
    }

    private T readBoolean(DynamicProperty property) {
        return (T)property.getBoolean();
    }

    private T readDouble(DynamicProperty property) {
        return (T)property.getDouble();
    }

    private T readFloat(DynamicProperty property) {
        return (T)property.getFloat();
    }

    public String[] getPriorityKeys() {
        return this.propertyType.getPriorityKeys();
    }

    public T getDefaultValue() {
        return this.propertyType.getDefaultValue();
    }

    public DynamicProperty[] getProperties() {
        return this.properties;
    }

    void initValue() {
        String effectiveKey = this.doUpdateFinalValue();
        LOGGER.debug("config inited, \"{}\" set to {}, effective key is \"{}\".", new Object[]{this.joinedPriorityKeys, this.finalValue, effectiveKey});
    }

    synchronized boolean updateValue() {
        T lastValue = this.finalValue;
        String effectiveKey = this.doUpdateFinalValue();
        if (effectiveKey != null) {
            LOGGER.debug("config changed, \"{}\" changed from {} to {}, effective key is \"{}\".", new Object[]{this.joinedPriorityKeys, lastValue, this.finalValue, effectiveKey});
            return true;
        }
        return false;
    }

    private String doUpdateFinalValue() {
        T lastValue = this.finalValue;
        String effectiveKey = "default value";
        T value = this.propertyType.getDefaultValue();
        for (DynamicProperty property : this.properties) {
            T propValue = this.internalValueReader.apply(property);
            if (propValue == null || propValue.equals(this.propertyType.getInvalidValue())) continue;
            effectiveKey = property.getName();
            value = propValue;
            break;
        }
        if (Objects.equals(lastValue, value)) {
            return null;
        }
        this.finalValue = value;
        return effectiveKey;
    }

    public T getValue() {
        return this.finalValue;
    }

    public boolean isChangedKey(String changedKey) {
        if (changedKey == null) {
            return true;
        }
        for (DynamicProperty property : this.properties) {
            if (!changedKey.equals(property.getName())) continue;
            return true;
        }
        return false;
    }
}

