/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.filter;

import org.apache.servicecomb.core.filter.Filter;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public abstract class AbstractFilter
implements Filter,
EnvironmentAware {
    private static final String ORDER_KEY = "servicecomb.filter.%s.%s.%s.order";
    private static final String ENABLE_KEY = "servicecomb.filter.%s.%s.%s.enabled";
    protected Environment environment;
    private String nameWithOrder;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Override
    public int getOrder(String application, String serviceName) {
        Integer custom = (Integer)this.environment.getProperty(String.format(ORDER_KEY, this.getName(), application, serviceName), Integer.class);
        if (custom != null) {
            return custom;
        }
        return this.getOrder();
    }

    @Override
    public boolean enabledForMicroservice(String application, String serviceName) {
        Boolean custom = (Boolean)this.environment.getProperty(String.format(ENABLE_KEY, this.getName(), application, serviceName), Boolean.class);
        if (custom != null) {
            return custom;
        }
        return true;
    }

    @Override
    public String getNameWithOrder() {
        if (this.nameWithOrder == null) {
            this.nameWithOrder = String.format("F(%1$06d)-%2$s", this.getOrder(), this.getName());
        }
        return this.nameWithOrder;
    }
}

