/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.codec.protobuf.schema;

import com.google.common.hash.Hashing;
import io.protostuff.compiler.model.Proto;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.foundation.common.utils.StringBuilderUtils;
import org.apache.servicecomb.foundation.protobuf.internal.parser.ProtoParser;
import org.apache.servicecomb.swagger.SwaggerUtils;

public class SchemaToProtoGenerator {
    private final String protoPackage;
    private final OpenAPI openAPI;
    private final Schema<?> rootSchema;
    private final String rootName;
    private final Set<String> messages = new HashSet<String>();
    private final StringBuilder msgStringBuilder = new StringBuilder();
    private List<Runnable> pending = new ArrayList<Runnable>();

    public SchemaToProtoGenerator(String protoPackage, OpenAPI openAPI, Schema<?> rootSchema, String rootName) {
        this.protoPackage = protoPackage;
        this.openAPI = openAPI;
        this.rootSchema = rootSchema;
        this.rootName = rootName;
    }

    public Proto convert() {
        this.createMessage(this.rootSchema);
        int iteration = 0;
        do {
            List<Runnable> oldPending = this.pending;
            this.pending = new ArrayList<Runnable>();
            for (Runnable runnable : oldPending) {
                runnable.run();
            }
            if (this.pending.size() < oldPending.size()) continue;
            ++iteration;
        } while (!this.pending.isEmpty() && iteration < 1000);
        if (iteration == 1000) {
            throw new IllegalArgumentException(String.format("Failed to create schema %s. May be cyclic object.", this.rootName));
        }
        HashMap<String, Schema> wrap = new HashMap<String, Schema>(1);
        wrap.put("value", this.rootSchema);
        this.createMessage(this.rootName, wrap, "@WrapProperty");
        return this.createProto();
    }

    protected Proto createProto() {
        StringBuilder sb = new StringBuilder();
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"syntax = \"proto3\";", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((CharSequence)this.protoPackage)) {
            sb.append("package ").append(this.protoPackage).append(";\n");
        }
        sb.append((CharSequence)this.msgStringBuilder);
        ProtoParser protoParser = new ProtoParser();
        return protoParser.parseFromContent(sb.toString());
    }

    private String findSchemaType(Schema<?> schema) {
        String type = this.tryFindEnumType(schema.getEnum());
        if (type != null) {
            return type;
        }
        type = this.findBaseType(schema.getType(), schema.getFormat());
        if (type != null) {
            return type;
        }
        Schema itemProperty = schema.getItems();
        if (itemProperty != null) {
            String containerType = this.findArrayOrMapItemType(itemProperty);
            if (containerType != null) {
                return "repeated " + containerType;
            }
            return null;
        }
        itemProperty = (Schema)schema.getAdditionalProperties();
        if (itemProperty != null) {
            String containerType = this.findArrayOrMapItemType(itemProperty);
            if (containerType != null) {
                return String.format("map<string, %s>", containerType);
            }
            return null;
        }
        type = schema.get$ref();
        if (type != null) {
            String typeName = type.substring("#/components/schemas/".length());
            Schema refSchema = (Schema)this.openAPI.getComponents().getSchemas().get(typeName);
            if (refSchema == null) {
                throw new IllegalArgumentException("not found ref in components " + type);
            }
            if (StringUtils.isEmpty((CharSequence)refSchema.getName())) {
                refSchema.setName(typeName);
            }
            return this.findSchemaType(refSchema);
        }
        return this.findObjectType(schema);
    }

    private String findObjectType(Schema<?> schema) {
        String name = schema.getName();
        if (this.messages.contains(name)) {
            return name;
        }
        return null;
    }

    private void createEnum(String enumName, List<String> enums) {
        if (!this.messages.add(enumName)) {
            return;
        }
        StringBuilderUtils.appendLine((StringBuilder)this.msgStringBuilder, (String)"enum %s {", (Object[])new Object[]{enumName});
        for (int idx = 0; idx < enums.size(); ++idx) {
            if (!SchemaToProtoGenerator.isValidEnum(enums.get(idx))) {
                throw new IllegalStateException(String.format("enum class [%s] name [%s] not supported by protobuffer.", enumName, enums.get(idx)));
            }
            StringBuilderUtils.appendLine((StringBuilder)this.msgStringBuilder, (String)"  %s =%d;", (Object[])new Object[]{enums.get(idx), idx});
        }
        StringBuilderUtils.appendLine((StringBuilder)this.msgStringBuilder, (String)"}", (Object[])new Object[0]);
    }

    public static boolean isValidEnum(String name) {
        return !name.contains(".") && !name.contains("-");
    }

    private String tryFindEnumType(List<String> enums) {
        if (enums != null && !enums.isEmpty()) {
            String strEnums = enums.toString();
            String enumName = "Enum_" + Hashing.sha256().hashString((CharSequence)strEnums, StandardCharsets.UTF_8);
            this.pending.add(() -> this.createEnum(enumName, enums));
            return enumName;
        }
        return null;
    }

    private String findBaseType(String swaggerType, String swaggerFmt) {
        String key;
        return switch (key = swaggerType + ":" + swaggerFmt) {
            case "boolean:null" -> "bool";
            case "integer:int32" -> "sint32";
            case "integer:int64" -> "sint64";
            case "integer:null" -> "string";
            case "number:double" -> "double";
            case "number:float" -> "float";
            case "number:null" -> "string";
            case "string:null" -> "string";
            case "string:byte" -> "bytes";
            case "string:date" -> "int64";
            case "string:date-time" -> "int64";
            case "string:binary" -> throw new IllegalArgumentException("proto buffer not support file upload/download");
            default -> null;
        };
    }

    private String findArrayOrMapItemType(Schema<?> itemProperty) {
        if (itemProperty.getItems() != null) {
            return this.findWrapPropertyType(List.class.getSimpleName(), itemProperty.getItems());
        }
        if (itemProperty.getAdditionalProperties() != null) {
            return this.findWrapPropertyType(Map.class.getSimpleName(), (Schema)itemProperty.getAdditionalProperties());
        }
        return this.findSchemaType(itemProperty);
    }

    private String findWrapPropertyType(String prefix, Schema<?> property) {
        if (property.getItems() != null) {
            return this.findWrapPropertyType(prefix + List.class.getSimpleName(), property.getItems());
        }
        if (property.getAdditionalProperties() != null) {
            return this.findWrapPropertyType(prefix + Map.class.getSimpleName(), (Schema)property.getAdditionalProperties());
        }
        String type = this.findSchemaType(property);
        if (type == null) {
            return null;
        }
        return prefix + StringUtils.capitalize((String)SchemaToProtoGenerator.escapeMessageName(type));
    }

    public static String escapeMessageName(String name) {
        return name.replaceAll("\\.", "_");
    }

    private void wrapPropertyToMessage(String protoName, Schema<?> property) {
        this.createMessage(protoName, Collections.singletonMap("value", property), "@WrapProperty");
    }

    private void createMessage(String protoName, Map<String, Schema> properties, String ... annotations) {
        for (String annotation : annotations) {
            this.msgStringBuilder.append("//");
            StringBuilderUtils.appendLine((StringBuilder)this.msgStringBuilder, (String)annotation, (Object[])new Object[0]);
        }
        StringBuilderUtils.appendLine((StringBuilder)this.msgStringBuilder, (String)"message %s {", (Object[])new Object[]{protoName});
        int tag = 1;
        for (Map.Entry<String, Schema> entry : properties.entrySet()) {
            Schema property = entry.getValue();
            String propertyType = this.findSchemaType(property);
            StringBuilderUtils.appendLine((StringBuilder)this.msgStringBuilder, (String)"  %s %s = %d;", (Object[])new Object[]{propertyType, entry.getKey(), tag});
            ++tag;
        }
        StringBuilderUtils.appendLine((StringBuilder)this.msgStringBuilder, (String)"}", (Object[])new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public void createMessage(Schema<?> schema) {
        String ref = schema.get$ref();
        if (ref != null) {
            String typeName = ref.substring("#/components/schemas/".length());
            Schema refSchema = (Schema)this.openAPI.getComponents().getSchemas().get(typeName);
            if (refSchema == null) {
                throw new IllegalArgumentException("not found ref in components " + ref);
            }
            if (StringUtils.isEmpty((CharSequence)refSchema.getName())) {
                refSchema.setName(typeName);
            }
            this.createMessage(refSchema);
            return;
        }
        boolean wait = false;
        if (this.isArrayOrMap(schema)) {
            Schema<?> mapOrArrayItem = this.arrayOrMapItem(schema);
            if (this.findSchemaType(mapOrArrayItem) == null) {
                this.createMessageTask(mapOrArrayItem);
                wait = true;
            } else if (this.createMapOrArrayMessageTask(mapOrArrayItem, true, schema)) {
                wait = true;
            }
        }
        if (schema.getProperties() != null) {
            for (Map.Entry entry : schema.getProperties().entrySet()) {
                if (this.findSchemaType((Schema)entry.getValue()) == null) {
                    this.createMessageTask((Schema)entry.getValue());
                    wait = true;
                    continue;
                }
                if (!this.isArrayOrMap((Schema)entry.getValue()) || !this.createMapOrArrayMessageTask(this.arrayOrMapItem((Schema)entry.getValue()), false, null)) continue;
                wait = true;
            }
        }
        if (wait) {
            IdentifierRunnable runnable = new IdentifierRunnable(schema, () -> this.createMessage(schema));
            if (!this.pending.contains(runnable)) {
                this.pending.add(runnable);
            }
            return;
        }
        if (this.findSchemaType(schema) != null) {
            return;
        }
        this.messages.add(schema.getName());
        StringBuilderUtils.appendLine((StringBuilder)this.msgStringBuilder, (String)"message %s {", (Object[])new Object[]{schema.getName()});
        ArrayList sortedProperties = new ArrayList(schema.getProperties().entrySet());
        sortedProperties.sort(Comparator.comparing(Map.Entry::getKey));
        boolean bl = true;
        for (Map.Entry entry : sortedProperties) {
            void var5_9;
            Schema property = (Schema)entry.getValue();
            String propertyType = this.findSchemaType(property);
            StringBuilderUtils.appendLine((StringBuilder)this.msgStringBuilder, (String)"  %s %s = %d;", (Object[])new Object[]{propertyType, entry.getKey(), (int)var5_9});
            ++var5_9;
        }
        StringBuilderUtils.appendLine((StringBuilder)this.msgStringBuilder, (String)"}", (Object[])new Object[0]);
    }

    private boolean isArrayOrMap(Schema<?> value) {
        return value.getItems() != null || value.getAdditionalProperties() != null;
    }

    private Schema<?> arrayOrMapItem(Schema<?> schema) {
        return schema.getItems() == null ? (Schema)schema.getAdditionalProperties() : schema.getItems();
    }

    private void createMessageTask(Schema<?> schema) {
        IdentifierRunnable runnable = new IdentifierRunnable(schema, () -> this.createMessage(schema));
        if (!this.pending.contains(runnable)) {
            this.pending.add(runnable);
        }
    }

    private boolean createMapOrArrayMessageTask(Schema<?> schema, boolean nested, Schema<?> owner) {
        String protoName;
        if (schema.getAdditionalProperties() != null && this.messages.add(protoName = this.findWrapPropertyType(Map.class.getSimpleName(), (Schema)schema.getAdditionalProperties()))) {
            this.pending.add(() -> this.wrapPropertyToMessage(protoName, schema));
            this.createMessageTask((Schema)schema.getAdditionalProperties());
            return true;
        }
        if (schema.getItems() != null && this.messages.add(protoName = this.findWrapPropertyType(List.class.getSimpleName(), schema.getItems()))) {
            this.pending.add(() -> this.wrapPropertyToMessage(protoName, schema));
            this.createMessageTask(schema.getItems());
            return true;
        }
        if (nested) {
            String string = protoName = owner.getAdditionalProperties() != null ? this.findWrapPropertyType(Map.class.getSimpleName(), schema) : this.findWrapPropertyType(List.class.getSimpleName(), schema);
            if (this.messages.add(protoName)) {
                this.pending.add(() -> this.wrapPropertyToMessage(protoName, owner));
                return true;
            }
        }
        return false;
    }

    record IdentifierRunnable(Schema<?> identifier, Runnable target) implements Runnable
    {
        @Override
        public void run() {
            this.target.run();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IdentifierRunnable that = (IdentifierRunnable)o;
            return SwaggerUtils.schemaEquals(this.identifier, that.identifier);
        }

        @Override
        public int hashCode() {
            return SwaggerUtils.schemaHashCode(this.identifier);
        }
    }
}

