/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.sync.content.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.sling.ide.filter.FilterResult;
import org.apache.sling.ide.log.Logger;
import org.apache.sling.ide.serialization.SerializationKind;
import org.apache.sling.ide.serialization.SerializationKindManager;
import org.apache.sling.ide.serialization.SerializationManager;
import org.apache.sling.ide.sync.content.SyncCommandFactory;
import org.apache.sling.ide.sync.content.WorkspaceDirectory;
import org.apache.sling.ide.sync.content.WorkspaceFile;
import org.apache.sling.ide.sync.content.WorkspacePath;
import org.apache.sling.ide.sync.content.WorkspaceResource;
import org.apache.sling.ide.transport.Command;
import org.apache.sling.ide.transport.CommandContext;
import org.apache.sling.ide.transport.Repository;
import org.apache.sling.ide.transport.RepositoryException;
import org.apache.sling.ide.transport.RepositoryPath;
import org.apache.sling.ide.transport.ResourceAndInfo;
import org.apache.sling.ide.transport.ResourceProxy;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SyncCommandFactory.class})
public class DefaultSyncCommandFactory
implements SyncCommandFactory {
    private final SerializationManager serializationManager;
    private final Logger logger;

    @Activate
    public DefaultSyncCommandFactory(@Reference SerializationManager serializationManager, @Reference Logger logger) {
        this.serializationManager = serializationManager;
        this.logger = logger;
    }

    @Override
    public Command<?> newCommandForRemovedResource(Repository repository, WorkspaceResource resource) throws IOException {
        if (resource.isIgnored()) {
            this.logger.trace("Skipping ignored resource {0}", resource);
            return null;
        }
        WorkspacePath resourceLocalPath = resource.getPathRelativeToSyncDir().absolute();
        RepositoryPath repositoryPath = this.serializationManager.getRepositoryPath(resourceLocalPath);
        FilterResult filterResult = resource.getProject().getFilter().filter(repositoryPath);
        this.logger.trace("Filter result for {0} is {1}", new Object[]{repositoryPath, filterResult});
        if (filterResult == null || filterResult == FilterResult.DENY || filterResult == FilterResult.PREREQUISITE) {
            return null;
        }
        WorkspaceFile serializationFile = this.serializationManager.getSerializationFile(resource, SerializationKind.FOLDER);
        ResourceProxy coveringParentData = this.findSerializationDataFromCoveringParent(resource, resourceLocalPath, serializationFile.getLocalPath());
        if (coveringParentData != null) {
            this.logger.trace("Found covering resource data ( repository path = {0} ) for resource at {1},  skipping deletion and performing an update instead", coveringParentData.getPath(), resource.getLocalPath());
            WorkspaceFile info = resource instanceof WorkspaceFile ? (WorkspaceFile)resource : null;
            return repository.newAddOrUpdateNodeCommand(new CommandContext(resource.getProject().getFilter()), info, coveringParentData, new Repository.CommandExecutionFlag[0]);
        }
        return repository.newDeleteNodeCommand(this.serializationManager.getRepositoryPath(resourceLocalPath));
    }

    @Override
    public Command<?> newCommandForAddedOrUpdatedResource(Repository repository, WorkspaceResource resource) throws IOException {
        ResourceAndInfo rai = this.buildResourceAndInfo(resource, repository);
        if (rai == null) {
            return null;
        }
        CommandContext context = new CommandContext(resource.getProject().getFilter());
        if (rai.isOnlyWhenMissing()) {
            return repository.newAddOrUpdateNodeCommand(context, rai.getInfo(), rai.getResource(), Repository.CommandExecutionFlag.CREATE_ONLY_WHEN_MISSING);
        }
        return repository.newAddOrUpdateNodeCommand(context, rai.getInfo(), rai.getResource(), new Repository.CommandExecutionFlag[0]);
    }

    private ResourceProxy findSerializationDataFromCoveringParent(WorkspaceResource localFile, WorkspacePath resourceLocalPath, WorkspacePath serializationFilePath) throws IOException {
        this.logger.trace("Found plain nt:folder candidate at {0}, trying to find a covering resource for it", localFile);
        WorkspacePath syncDirPath = localFile.getProject().getSyncDirectory().getLocalPath();
        WorkspacePath projectPath = localFile.getProject().getLocalPath();
        while (!syncDirPath.equals(serializationFilePath) && (serializationFilePath = serializationFilePath.getParent()).asPortableString().lastIndexOf(47) != 0) {
            WorkspacePath projectRelativePath = projectPath.relativize(serializationFilePath);
            WorkspaceDirectory folderWithPossibleSerializationFile = localFile.getProject().getDirectory(projectRelativePath);
            if (!folderWithPossibleSerializationFile.exists()) {
                this.logger.trace("No folder found at {0}, moving up to the next level", serializationFilePath);
                continue;
            }
            WorkspaceFile possibleSerializationFile = this.serializationManager.getSerializationFile(folderWithPossibleSerializationFile, SerializationKind.METADATA_PARTIAL);
            this.logger.trace("Looking for serialization data in {0}", possibleSerializationFile);
            if (!this.serializationManager.isSerializationFile(possibleSerializationFile)) continue;
            if (!possibleSerializationFile.exists()) {
                this.logger.trace("Potential serialization data file {0} does not exist, moving up to the next level", possibleSerializationFile.getLocalPath());
                continue;
            }
            ResourceProxy serializationData = this.serializationManager.readSerializationData(possibleSerializationFile);
            RepositoryPath repositoryPath = this.serializationManager.getRepositoryPath(resourceLocalPath);
            RepositoryPath potentialPath = serializationData.getPath();
            boolean covered = serializationData.covers(repositoryPath);
            this.logger.trace("Found possible serialization data at {0}. Resource :{1} ; our resource: {2}. Covered: {3}", possibleSerializationFile, potentialPath, repositoryPath, covered);
            if (!covered) break;
            return serializationData.getChild(repositoryPath);
        }
        return null;
    }

    @Override
    public ResourceAndInfo buildResourceAndInfo(WorkspaceResource resource, Repository repository) throws IOException {
        if (!resource.exists()) {
            return null;
        }
        if (resource.isIgnored()) {
            this.logger.trace("Skipping team-private resource {0}", resource);
            return null;
        }
        Long modificationTimestamp = (Long)resource.getTransientProperty("importModificationTimestamp");
        if (modificationTimestamp != null && modificationTimestamp >= resource.getLastModified()) {
            this.logger.trace("Change for resource {0} ignored as the import timestamp {1} >= modification timestamp {2}", resource, modificationTimestamp, resource.getLastModified());
            return null;
        }
        WorkspaceFile info = resource instanceof WorkspaceFile ? (WorkspaceFile)resource : null;
        this.logger.trace("For {0} built fileInfo {1}", resource, info);
        ResourceProxy resourceProxy = null;
        if (info != null && this.serializationManager.isSerializationFile((WorkspaceFile)resource)) {
            resourceProxy = this.serializationManager.readSerializationData(info);
            this.normaliseResourceChildren(info, resourceProxy, repository);
            String primaryType = (String)resourceProxy.getProperties().get("jcr:primaryType");
            if ("nt:file".equals(primaryType)) {
                WorkspacePath originalPath = info.getPathRelativeToSyncDir();
                WorkspaceDirectory parent = info.getParent();
                String mainFileName = info.getName().replaceAll("\\.dir^", "");
                info = parent.getFile(new WorkspacePath(mainFileName));
                WorkspacePath adjustedPath = info.getPathRelativeToSyncDir();
                this.logger.trace("Adjusted original location from {0} to {1}", originalPath, adjustedPath);
            }
        } else {
            WorkspaceDirectory folder;
            WorkspaceFile contentXml;
            if (resource instanceof WorkspaceDirectory && resource.getName().endsWith(".dir") && (contentXml = (folder = (WorkspaceDirectory)resource).getFile(new WorkspacePath(".content.xml"))).exists() && contentXml instanceof WorkspaceFile && this.serializationManager.isSerializationFile(contentXml)) {
                return null;
            }
            resourceProxy = this.buildResourceProxyForPlainFileOrFolder(resource, repository);
        }
        if (resourceProxy == null) {
            throw new RuntimeException("ResourceProxy is null for resource " + String.valueOf(resource));
        }
        FilterResult filterResult = resource.getProject().getFilter().filter(resourceProxy.getPath());
        switch (filterResult) {
            case ALLOW: {
                return new ResourceAndInfo(resourceProxy, info);
            }
            case PREREQUISITE: {
                if (resourceProxy.getPath().equals("/")) break;
                return new ResourceAndInfo(new ResourceProxy(resourceProxy.getPath()), null, true);
            }
        }
        return null;
    }

    private ResourceProxy buildResourceProxyForPlainFileOrFolder(WorkspaceResource changedResource, Repository repository) throws IOException {
        ResourceProxy dataFromCoveringParent;
        String fallbackNodeType;
        SerializationKind serializationKind;
        if (changedResource instanceof WorkspaceFile) {
            serializationKind = SerializationKind.FILE;
            fallbackNodeType = "nt:file";
        } else {
            serializationKind = SerializationKind.FOLDER;
            fallbackNodeType = "nt:folder";
        }
        WorkspacePath resourceLocation = changedResource.getPathRelativeToSyncDir();
        WorkspaceFile serializationResource = this.serializationManager.getSerializationFile(changedResource, serializationKind);
        if (!serializationResource.exists() && changedResource instanceof WorkspaceDirectory && (dataFromCoveringParent = this.findSerializationDataFromCoveringParent(changedResource, resourceLocation, serializationResource.getLocalPath())) != null) {
            return dataFromCoveringParent;
        }
        return this.buildResourceProxy(resourceLocation, serializationResource, fallbackNodeType, repository);
    }

    private ResourceProxy buildResourceProxy(WorkspacePath resourceLocation, WorkspaceFile serializationFile, String fallbackPrimaryType, Repository repository) throws IOException {
        if (serializationFile.exists()) {
            ResourceProxy resourceProxy = this.serializationManager.readSerializationData(serializationFile);
            this.normaliseResourceChildren(serializationFile, resourceProxy, repository);
            return resourceProxy;
        }
        return new ResourceProxy(this.serializationManager.getRepositoryPath(resourceLocation), Collections.singletonMap("jcr:primaryType", fallbackPrimaryType));
    }

    private void normaliseResourceChildren(WorkspaceFile serializationFile, ResourceProxy resourceProxy, Repository repository) {
        try {
            SerializationKindManager skm = new SerializationKindManager();
            skm.init(repository);
            String primaryType = (String)resourceProxy.getProperties().get("jcr:primaryType");
            List<String> mixinTypesList = this.getMixinTypes(resourceProxy);
            SerializationKind serializationKind = skm.getSerializationKind(primaryType, mixinTypesList);
            if (serializationKind == SerializationKind.METADATA_FULL) {
                return;
            }
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        WorkspacePath serializationDirectoryPath = serializationFile.getLocalPath().getParent();
        Iterator<ResourceProxy> childIterator = resourceProxy.getChildren().iterator();
        HashMap<String, WorkspaceResource> extraChildResources = new HashMap<String, WorkspaceResource>();
        for (WorkspaceResource member : serializationFile.getParent().getChildren()) {
            if (member.equals(serializationFile)) continue;
            extraChildResources.put(member.getName(), member);
        }
        while (childIterator.hasNext()) {
            ResourceProxy child = childIterator.next();
            String childName = child.getPath().getName();
            String osChildName = this.serializationManager.getLocalName(childName);
            extraChildResources.remove(osChildName);
            if (resourceProxy.covers(child.getPath())) continue;
            WorkspacePath childPath = serializationDirectoryPath.append(osChildName);
            WorkspaceDirectory childResource = serializationFile.getParent().getDirectory(new WorkspacePath(osChildName));
            if (childResource.exists()) continue;
            this.logger.trace("For resource at with serialization data {0} the serialized child resource at {1} does not exist in the filesystem and will be ignored", serializationFile, childPath);
            childIterator.remove();
        }
        for (WorkspaceResource extraChildResource : extraChildResources.values()) {
            WorkspacePath extraChildResourcePath = extraChildResource.getPathRelativeToSyncDir();
            resourceProxy.addChild(new ResourceProxy(this.serializationManager.getRepositoryPath(extraChildResourcePath)));
            this.logger.trace("For resource at with serialization data {0} the found a child resource at {1} which is not listed in the serialized child resources and will be added", serializationFile, extraChildResource);
        }
    }

    private List<String> getMixinTypes(ResourceProxy resourceProxy) {
        Object mixinTypesProp = resourceProxy.getProperties().get("jcr:mixinTypes");
        if (mixinTypesProp == null) {
            return Collections.emptyList();
        }
        if (mixinTypesProp instanceof String) {
            return Collections.singletonList((String)mixinTypesProp);
        }
        return Arrays.asList((String[])mixinTypesProp);
    }

    @Override
    public Command<Void> newReorderChildNodesCommand(Repository repository, WorkspaceResource resource) throws IOException {
        ResourceAndInfo rai = this.buildResourceAndInfo(resource, repository);
        if (rai == null || rai.isOnlyWhenMissing()) {
            return null;
        }
        return repository.newReorderChildNodesCommand(rai.getResource());
    }
}

