/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client.impl;

import org.apache.sling.auth.oauth_client.impl.TokenState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OAuthToken {
    private final TokenState state;
    private final String value;

    public OAuthToken(@NotNull TokenState state, @Nullable String value) {
        this.state = state;
        if (TokenState.VALID == state && value == null) {
            throw new IllegalArgumentException("Token state is VALID but no token value is provided");
        }
        this.value = value;
    }

    public OAuthToken(@NotNull String value) {
        this.state = TokenState.VALID;
        this.value = value;
    }

    @NotNull
    public TokenState getState() {
        return this.state;
    }

    @NotNull
    public String getValue() {
        if (this.state != TokenState.VALID) {
            throw new IllegalStateException("Can't retrieve a token value when the token state is " + String.valueOf((Object)this.state));
        }
        if (this.value == null) {
            throw new IllegalStateException("Token state is VALID but no token value is provided");
        }
        return this.value;
    }
}

