/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.filters;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.CMSUtils;
import org.apache.sling.cms.PublishableResource;
import org.apache.sling.cms.core.internal.filters.CMSSecurityConfigInstance;
import org.apache.sling.cms.publication.PUBLICATION_MODE;
import org.apache.sling.cms.publication.PublicationManagerFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Filter.class}, property={"sling.filter.scope=request"}, immediate=true)
public class CMSSecurityFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(CMSSecurityFilter.class);
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    private List<CMSSecurityConfigInstance> securityConfigInstances;
    @Reference
    private PublicationManagerFactory pubMgrFactory;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.pubMgrFactory.getPublicationMode() == PUBLICATION_MODE.STANDALONE) {
            SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
            for (CMSSecurityConfigInstance securityConfig : this.securityConfigInstances) {
                if (securityConfig.applies((HttpServletRequest)slingRequest)) {
                    log.trace("Security config {} applies to request to {}", (Object)securityConfig, (Object)request.getServerName());
                    boolean allowed = this.checkAllowed(securityConfig, slingRequest);
                    if (!allowed) {
                        log.trace("Request to {} not allowed for user {}", (Object)slingRequest.getRequestURL(), (Object)slingRequest.getResourceResolver().getUserID());
                        ((HttpServletResponse)response).sendError(401);
                        return;
                    }
                    log.trace("Request {} allowed", (Object)slingRequest.getRequestURL());
                    continue;
                }
                log.trace("Security config {} does not apply to request to {}", (Object)securityConfig, (Object)request.getServerName());
            }
        } else {
            log.trace("Publication mode {} is not standalone", (Object)this.pubMgrFactory.getPublicationMode());
        }
        chain.doFilter(request, response);
    }

    private boolean checkAllowed(CMSSecurityConfigInstance securityConfig, SlingHttpServletRequest slingRequest) {
        PublishableResource publishableResource;
        log.trace("Filtering requests to host {}", (Object)slingRequest.getServerName());
        String uri = slingRequest.getRequestURI();
        boolean allowed = false;
        if (securityConfig.isUriAllowed(uri)) {
            log.trace("Allowing request to uri {} based on allow patterns", (Object)uri);
            allowed = true;
        }
        if ((publishableResource = (PublishableResource)Optional.ofNullable(CMSUtils.findPublishableParent((Resource)slingRequest.getResource())).map(r -> (PublishableResource)r.adaptTo(PublishableResource.class)).orElse(null)) != null && publishableResource.isPublished()) {
            log.trace("Resource is published");
            allowed = true;
        }
        if (!allowed) {
            log.trace("Request to {} not public, checking user permissions", (Object)uri);
            if (StringUtils.isNotBlank((CharSequence)securityConfig.getGroupName())) {
                allowed = this.checkGroupMembership(securityConfig, slingRequest);
            } else if (!"anonymous".equals(slingRequest.getResourceResolver().getUserID())) {
                allowed = true;
            }
        } else {
            log.trace("Request to {} allowed", (Object)uri);
        }
        return allowed;
    }

    private boolean checkGroupMembership(CMSSecurityConfigInstance securityConfig, SlingHttpServletRequest slingRequest) {
        boolean allowed = false;
        try {
            Session session = (Session)slingRequest.getResourceResolver().adaptTo(Session.class);
            UserManager userManager = null;
            if (session instanceof JackrabbitSession) {
                userManager = ((JackrabbitSession)session).getUserManager();
            }
            if (userManager == null) {
                log.warn("Unable to retrieve user manager");
                return false;
            }
            log.trace("Retrieved user manager {} with session {}", (Object)userManager, (Object)session);
            Authorizable auth = userManager.getAuthorizable(slingRequest.getUserPrincipal());
            if (auth == null) {
                log.warn("Unable to retrieve user from principal {}", (Object)slingRequest.getUserPrincipal());
                return false;
            }
            log.trace("Checking to see if user {} is in required group {}", (Object)auth.getID(), (Object)securityConfig.getGroupName());
            Iterator groups = ((User)auth).memberOf();
            while (groups.hasNext()) {
                if (!((Group)groups.next()).getID().equals(securityConfig.getGroupName())) continue;
                allowed = true;
                break;
            }
        }
        catch (RepositoryException e) {
            log.error("Unexpected exception checking group membership", (Throwable)e);
            return false;
        }
        return allowed;
    }

    public void destroy() {
    }
}

