/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.contentdetection.internal;

import java.io.IOException;
import java.io.InputStream;
import org.apache.sling.commons.contentdetection.ContentAwareMimeTypeService;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.description=Apache Sling Content Aware MIME Type Service", "service.vendor=The Apache Software Foundation", "detection.mode=tika"})
public class ContentAwareMimeTypeServiceImpl
implements ContentAwareMimeTypeService {
    @Reference
    Detector detector;
    @Reference
    MimeTypeService mimeTypeService;

    @Override
    public String getMimeType(String filename, InputStream content) throws IOException, IllegalArgumentException {
        MediaType mediaType;
        if (content == null) {
            return this.mimeTypeService.getMimeType(filename);
        }
        if (!content.markSupported()) {
            throw new IllegalArgumentException("Supplied InputStream does not support mark/reset");
        }
        try (TemporaryResources tmp = new TemporaryResources();){
            TikaInputStream stream = TikaInputStream.get((InputStream)content, (TemporaryResources)tmp);
            Metadata metadata = new Metadata();
            metadata.set("resourceName", filename);
            mediaType = this.detector.detect((InputStream)stream, metadata);
        }
        return mediaType.toString();
    }

    public String getMimeType(String name) {
        return this.mimeTypeService.getMimeType(name);
    }

    public String getExtension(String mimeType) {
        return this.mimeTypeService.getExtension(mimeType);
    }

    public void registerMimeType(String mimeType, String ... extensions) {
        this.mimeTypeService.registerMimeType(mimeType, extensions);
    }

    public void registerMimeType(InputStream mimeTabStream) throws IOException {
        this.mimeTypeService.registerMimeType(mimeTabStream);
    }
}

