/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.its.setup;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.LogManager;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.WriterAppender;

public class WithholdingAppender
extends WriterAppender {
    private final ByteArrayOutputStream baos;
    private final Writer writer;

    public static WithholdingAppender install() {
        LogManager.getRootLogger().removeAllAppenders();
        WithholdingAppender withholdingAppender = new WithholdingAppender((Layout)new PatternLayout("%d{dd.MM.yyyy HH:mm:ss.SSS} *%-5p* [%t] %c{1}: %m\n"));
        LogManager.getRootLogger().addAppender((Appender)withholdingAppender);
        return withholdingAppender;
    }

    public void release(boolean dumpToSysout) {
        LogManager.resetConfiguration();
        URL log4jPropertiesFile = ((Object)((Object)this)).getClass().getResource("/log4j.properties");
        PropertyConfigurator.configure((URL)log4jPropertiesFile);
        if (dumpToSysout) {
            String withheldLogoutput = this.getBuffer();
            System.out.println(withheldLogoutput);
        }
    }

    public WithholdingAppender(Layout layout) {
        this.layout = layout;
        this.baos = new ByteArrayOutputStream();
        this.writer = new BufferedWriter(new OutputStreamWriter(this.baos));
        this.setWriter(this.writer);
    }

    public String getBuffer() {
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.baos.toString();
    }
}

