/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.cluster;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.discovery.impl.Config;
import org.apache.sling.discovery.impl.DiscoveryServiceImpl;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class ClusterViewChangeListener
implements EventHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private SlingSettingsService slingSettingsService;
    @Reference
    private ResourceResolverFactory resolverFactory;
    @Reference
    private DiscoveryServiceImpl discoveryService;
    @Reference
    private Config config;
    private String slingId;
    private ComponentContext context;
    private ServiceRegistration eventHandlerRegistration;

    @Activate
    protected void activate(ComponentContext context) {
        this.slingId = this.slingSettingsService.getSlingId();
        this.context = context;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("activated. slingid=" + this.slingId + ", discoveryservice=" + (Object)((Object)this.discoveryService));
        }
        this.registerEventHandler();
    }

    private void registerEventHandler() {
        BundleContext bundleContext;
        BundleContext bundleContext2 = bundleContext = this.context == null ? null : this.context.getBundleContext();
        if (bundleContext == null) {
            this.logger.info("registerEventHandler: context or bundleContext is null - cannot register");
            return;
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("service.description", "Cluster View Change Listener");
        String[] topics = new String[]{"org/apache/sling/api/resource/Resource/ADDED", "org/apache/sling/api/resource/Resource/CHANGED", "org/apache/sling/api/resource/Resource/REMOVED"};
        ((Dictionary)properties).put("event.topics", topics);
        String path = this.config.getDiscoveryResourcePath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        path = path + "/*";
        ((Dictionary)properties).put("event.filter", "(&(path=" + path + "))");
        this.eventHandlerRegistration = bundleContext.registerService(EventHandler.class.getName(), (Object)this, properties);
        this.logger.info("registerEventHandler: ClusterViewChangeHandler registered as EventHandler");
    }

    @Deactivate
    protected void deactivate() {
        if (this.eventHandlerRegistration != null) {
            this.eventHandlerRegistration.unregister();
            this.logger.info("deactivate: ClusterViewChangeHandler unregistered as EventHandler");
            this.eventHandlerRegistration = null;
        }
        this.logger.info("deactivate: deactivated slingId: {}, this: {}", (Object)this.slingId, (Object)this);
    }

    public void handleEvent(Event event) {
        String resourcePath = (String)event.getProperty("path");
        if (this.config == null) {
            return;
        }
        String establishedViewPath = this.config.getEstablishedViewPath();
        String clusterInstancesPath = this.config.getClusterInstancesPath();
        if (resourcePath == null) {
            return;
        }
        if (resourcePath.startsWith(establishedViewPath)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("handleEvent: establishedViewPath resourcePath=" + resourcePath + ", event=" + event);
            }
            this.handleTopologyChanged();
        } else if (resourcePath.startsWith(clusterInstancesPath)) {
            String[] resourceChangedAttributesStrings;
            Object resourceChangedAttributes = event.getProperty("resourceChangedAttributes");
            if (resourceChangedAttributes != null && resourceChangedAttributes instanceof String[] && (resourceChangedAttributesStrings = (String[])resourceChangedAttributes).length == 1 && resourceChangedAttributesStrings[0].equals("lastHeartbeat")) {
                return;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("handleEvent: clusterInstancesPath (announcement or properties) resourcePath=" + resourcePath + ", event=" + event);
            }
            this.handleTopologyChanged();
        } else {
            return;
        }
    }

    private void handleTopologyChanged() {
        this.logger.info("handleTopologyChanged: detected a change in the established views, invoking checkForTopologyChange.");
        this.discoveryService.checkForTopologyChange();
    }

    protected void bindSlingSettingsService(SlingSettingsService slingSettingsService) {
        this.slingSettingsService = slingSettingsService;
    }

    protected void unbindSlingSettingsService(SlingSettingsService slingSettingsService) {
        if (this.slingSettingsService == slingSettingsService) {
            this.slingSettingsService = null;
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindDiscoveryService(DiscoveryServiceImpl discoveryServiceImpl) {
        this.discoveryService = discoveryServiceImpl;
    }

    protected void unbindDiscoveryService(DiscoveryServiceImpl discoveryServiceImpl) {
        if (this.discoveryService == discoveryServiceImpl) {
            this.discoveryService = null;
        }
    }

    protected void bindConfig(Config config) {
        this.config = config;
    }

    protected void unbindConfig(Config config) {
        if (this.config == config) {
            this.config = null;
        }
    }
}

