/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.resources.impl.common;

import java.lang.reflect.Array;
import java.util.Map;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;

class SimpleReadableResource
extends AbstractResource {
    private final ResourceResolver resourceResolver;
    private final String resourcePath;
    private final Map<String, Object> properties;
    private final Object[] adapters;
    private final ResourceMetadata metadata = new ResourceMetadata();

    public SimpleReadableResource(ResourceResolver resourceResolver, String resourcePath, Map<String, Object> properties, Object ... adapters) {
        this.resourceResolver = resourceResolver;
        this.resourcePath = resourcePath;
        this.properties = properties;
        this.adapters = adapters;
    }

    public String getPath() {
        return this.resourcePath;
    }

    public String getResourceType() {
        Object rt = this.properties.get("sling:resourceType");
        if (rt != null) {
            return rt.toString();
        }
        return "nt:unstructured";
    }

    public String getResourceSuperType() {
        Object rt = this.properties.get("sling:resourceSuperType");
        if (rt != null) {
            return rt.toString();
        }
        return "nt:unstructured";
    }

    public ResourceMetadata getResourceMetadata() {
        return this.metadata;
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == ValueMap.class || type == Map.class) {
            return type.cast(new ValueMapDecorator(this.getProperties()));
        }
        if (this.adapters != null) {
            for (Object adapter : this.adapters) {
                if (adapter == null) continue;
                if (type.isArray()) {
                    if (!adapter.getClass().isArray()) continue;
                    Object[] adapterArray = (Object[])adapter;
                    return this.convertArray(type, adapterArray);
                }
                if (!type.isAssignableFrom(adapter.getClass())) continue;
                return type.cast(adapter);
            }
        }
        return (AdapterType)super.adaptTo(type);
    }

    private <ArrayType> ArrayType convertArray(Class<ArrayType> arrayType, Object[] array) {
        Object[] result = (Object[])Array.newInstance(arrayType.getComponentType(), array.length);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null && !arrayType.getComponentType().isAssignableFrom(array[i].getClass())) {
                return null;
            }
            result[i] = array[i];
        }
        return (ArrayType)result;
    }
}

