/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.api.artifacts;

import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.io.IOException;
import java.util.Calendar;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.extension.apiregions.api.artifacts.Mode;
import org.apache.sling.feature.extension.apiregions.api.config.AttributeableEntity;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class VersionRule
extends AttributeableEntity {
    private Mode mode;
    private ArtifactId artifactId;
    private String message;
    private VersionRange[] allowedVersionRanges;
    private VersionRange[] deniedVersionRanges;
    private String enforceOn;

    public VersionRule() {
        this.setDefaults();
    }

    @Override
    public void clear() {
        super.clear();
        this.setArtifactId(null);
        this.setMode(null);
        this.setMessage(null);
        this.setAllowedVersionRanges(null);
        this.setDeniedVersionRanges(null);
        this.setEnforceOn(null);
    }

    @Override
    public JsonObjectBuilder createJson() throws IOException {
        int i;
        String[] arr;
        JsonObjectBuilder objBuilder = super.createJson();
        if (this.getMode() != null) {
            objBuilder.add("mode", this.getMode().name());
        }
        if (this.getArtifactId() != null) {
            objBuilder.add("artifact-id", this.getArtifactId().toMvnId());
        }
        this.setString(objBuilder, "message", this.getMessage());
        if (this.getAllowedVersionRanges() != null && this.getAllowedVersionRanges().length > 0) {
            arr = new String[this.getAllowedVersionRanges().length];
            for (i = 0; i < this.getAllowedVersionRanges().length; ++i) {
                arr[i] = this.getAllowedVersionRanges()[i].toString();
            }
            this.setStringArray(objBuilder, "allowed-version-ranges", arr);
        }
        if (this.getDeniedVersionRanges() != null && this.getDeniedVersionRanges().length > 0) {
            arr = new String[this.getDeniedVersionRanges().length];
            for (i = 0; i < this.getDeniedVersionRanges().length; ++i) {
                arr[i] = this.getDeniedVersionRanges()[i].toString();
            }
            this.setStringArray(objBuilder, "denied-version-ranges", arr);
        }
        this.setString(objBuilder, "enforce-on", this.getEnforceOn());
        return objBuilder;
    }

    @Override
    public void fromJSONObject(JsonObject jsonObj) throws IOException {
        super.fromJSONObject(jsonObj);
        try {
            int i;
            VersionRange[] ranges;
            String val = this.getString("mode");
            if (val != null) {
                this.setMode(Mode.valueOf(val.toUpperCase()));
            }
            if ((val = this.getString("artifact-id")) != null) {
                this.setArtifactId(ArtifactId.parse((String)val));
            }
            this.setMessage(this.getString("message"));
            String[] arr = this.getStringArray("allowed-version-ranges");
            if (arr != null && arr.length > 0) {
                ranges = new VersionRange[arr.length];
                for (i = 0; i < arr.length; ++i) {
                    try {
                        ranges[i] = new VersionRange(arr[i]);
                        continue;
                    }
                    catch (IllegalArgumentException iae) {
                        throw new IOException("Illegal argument for allowed version range: " + arr[i]);
                    }
                }
                this.setAllowedVersionRanges(ranges);
            }
            if ((arr = this.getStringArray("denied-version-ranges")) != null && arr.length > 0) {
                ranges = new VersionRange[arr.length];
                for (i = 0; i < arr.length; ++i) {
                    try {
                        ranges[i] = new VersionRange(arr[i]);
                        continue;
                    }
                    catch (IllegalArgumentException iae) {
                        throw new IOException("Illegal argument for allowed version range: " + arr[i]);
                    }
                }
                this.setDeniedVersionRanges(ranges);
            }
            this.setEnforceOn(this.getString("enforce-on"));
        }
        catch (JsonException | IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode value) {
        this.mode = value;
    }

    public ArtifactId getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(ArtifactId artifactId) {
        this.artifactId = artifactId;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public VersionRange[] getAllowedVersionRanges() {
        return this.allowedVersionRanges;
    }

    public void setAllowedVersionRanges(VersionRange[] allowedVersions) {
        this.allowedVersionRanges = allowedVersions;
    }

    public VersionRange[] getDeniedVersionRanges() {
        return this.deniedVersionRanges;
    }

    public void setDeniedVersionRanges(VersionRange[] deniedVersions) {
        this.deniedVersionRanges = deniedVersions;
    }

    public boolean isAllowed(Version artifactVersion) {
        boolean result = false;
        if (this.getAllowedVersionRanges() != null && this.getAllowedVersionRanges().length > 0) {
            for (VersionRange range : this.getAllowedVersionRanges()) {
                if (!range.includes(artifactVersion)) continue;
                result = true;
                break;
            }
            if (result && this.getDeniedVersionRanges() != null) {
                for (VersionRange range : this.getDeniedVersionRanges()) {
                    if (!range.includes(artifactVersion)) continue;
                    result = false;
                    break;
                }
            }
        }
        return result;
    }

    private Calendar parseDate(String value) {
        String[] parts = value.split("-");
        if (parts.length == 3 && parts[0].length() == 4 && parts[1].length() == 2 && parts[2].length() == 2) {
            try {
                int year = Integer.parseInt(parts[0]);
                int month = Integer.parseInt(parts[1]);
                int day = Integer.parseInt(parts[2]);
                Calendar c = Calendar.getInstance();
                c.set(1, year);
                c.set(2, month - 1);
                c.set(5, day);
                c.set(11, 1);
                c.set(12, 0);
                c.set(13, 0);
                c.set(14, 0);
                return c;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getEnforceOn() {
        return this.enforceOn;
    }

    public void setEnforceOn(String enforceOn) {
        if (enforceOn != null && this.parseDate(enforceOn) == null) {
            throw new IllegalArgumentException("Enforce on date must be in the format 'YYYY-MM-DD'");
        }
        this.enforceOn = enforceOn;
    }

    public Calendar getEnforceOnDate() {
        Calendar result;
        Calendar calendar = result = this.enforceOn == null ? null : this.parseDate(this.enforceOn);
        if (result == null) {
            result = Calendar.getInstance();
            result.add(6, -1);
        }
        return result;
    }
}

