/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.featureflags.impl;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.featureflags.ExecutionContext;
import org.apache.sling.featureflags.Feature;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Designate(ocd=Config.class, factory=true)
@Component(service={Feature.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=The Apache Software Foundation"})
public class ConfiguredFeature
implements Feature {
    private static final String PROP_FEATURE = "feature";
    private String name;
    private String description;
    private boolean enabled;

    @Activate
    private void activate(Config config, Map<String, Object> properties) {
        this.name = config.name();
        if (this.name == null) {
            Object pid = properties.get("service.pid");
            this.name = pid == null ? this.getClass().getName() + "$" + System.identityHashCode(this) : pid.toString();
        }
        this.description = config.description();
        if (this.description == null) {
            this.description = this.name;
        }
        this.enabled = config.enabled();
    }

    @Override
    public boolean isEnabled(ExecutionContext context) {
        String[] features;
        HttpServletRequest request = context.getRequest();
        if (request != null && (features = request.getParameterValues(PROP_FEATURE)) != null) {
            for (String feature : features) {
                if (!this.name.equals(feature)) continue;
                return true;
            }
        }
        return this.enabled;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @ObjectClassDefinition(name="Apache Sling Configured Feature", description="Allows for the definition of statically configured features which are defined and enabled through OSGi configuration", factoryPid={"org.apache.sling.featureflags.Feature"})
    public static @interface Config {
        @AttributeDefinition(name="Name", description="Short name of this feature. This name is used to refer to this feature when checking for it to be enabled or not. This property is required and defaults to a name derived from the feature's class name and object identity. It is strongly recommended to define a useful and unique for the feature")
        public String name();

        @AttributeDefinition(name="Description", description="Description for the feature. The intent is to descibe the behaviour of the application if this feature would be enabled. It is recommended to define this property. The default value is the value of the name property.")
        public String description();

        @AttributeDefinition(name="Enabled", description="Boolean flag indicating whether the feature is enabled or not by this configuration")
        public boolean enabled() default false;
    }
}

