/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hapi.client.impl;

import java.net.URISyntaxException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.sling.hapi.client.HtmlClient;
import org.apache.sling.hapi.client.HtmlClientService;
import org.apache.sling.hapi.client.impl.microdata.MicrodataHtmlClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service(value={HtmlClientService.class})
public class HtmlClientServiceImpl
implements HtmlClientService {
    private final Logger LOG = LoggerFactory.getLogger(HtmlClientService.class);

    @Override
    public HtmlClient getClient(CloseableHttpClient client, String baseUrl) {
        try {
            return new MicrodataHtmlClient(client, baseUrl);
        }
        catch (URISyntaxException e) {
            this.LOG.error("Cannot instantiate client", (Throwable)e);
            return null;
        }
    }

    @Override
    public HtmlClient getClient(String baseUrl) {
        try {
            return new MicrodataHtmlClient(baseUrl);
        }
        catch (URISyntaxException e) {
            this.LOG.error("Cannot instantiate client", (Throwable)e);
            return null;
        }
    }

    @Override
    public HtmlClient getClient(String baseUrl, String user, String password) {
        try {
            return new MicrodataHtmlClient(baseUrl, user, password);
        }
        catch (URISyntaxException e) {
            this.LOG.error("Cannot instantiate client", (Throwable)e);
            return null;
        }
    }
}

