/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DynamicPooledExecutor
implements Executor {
    private static int instances = 0;
    private static ThreadPoolExecutor executor = null;
    private static long lastCheck;

    public DynamicPooledExecutor() {
        DynamicPooledExecutor.startInstance();
    }

    private static synchronized ThreadPoolExecutor adjustPoolSize() {
        long now = System.currentTimeMillis();
        if (lastCheck + 1000L < now) {
            int n = Runtime.getRuntime().availableProcessors();
            if (n != executor.getMaximumPoolSize()) {
                executor.setMaximumPoolSize(n);
            }
            lastCheck = now;
        }
        return executor;
    }

    @Override
    public void execute(Runnable command) {
        ThreadPoolExecutor executor = DynamicPooledExecutor.adjustPoolSize();
        if (executor.getMaximumPoolSize() == 1) {
            command.run();
        } else {
            executor.execute(command);
        }
    }

    public void close() {
        DynamicPooledExecutor.stopInstance();
    }

    private static synchronized void startInstance() {
        ++instances;
        if (executor == null) {
            ThreadFactory f = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r, "DynamicPooledExecutor");
                    t.setDaemon(true);
                    return t;
                }
            };
            executor = new ThreadPoolExecutor(1, Runtime.getRuntime().availableProcessors(), 500L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), f);
            lastCheck = System.currentTimeMillis();
        }
    }

    private static synchronized void stopInstance() {
        if (--instances == 0) {
            executor.shutdown();
            try {
                executor.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            executor = null;
        }
    }
}

