/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.repoinit.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.stream.Stream;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.value.BooleanValue;
import org.apache.jackrabbit.value.DateValue;
import org.apache.jackrabbit.value.DoubleValue;
import org.apache.jackrabbit.value.LongValue;
import org.apache.jackrabbit.value.StringValue;
import org.apache.sling.jcr.repoinit.impl.DoNothingVisitor;
import org.apache.sling.jcr.repoinit.impl.UserUtil;
import org.apache.sling.repoinit.parser.operations.PropertyLine;
import org.apache.sling.repoinit.parser.operations.SetProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NodePropertiesVisitor
extends DoNothingVisitor {
    private static final String PATH_AUTHORIZABLE = ":authorizable:";
    private static final char ID_DELIMINATOR = ',';
    private static final char SUBTREE_DELIMINATOR = '#';

    public NodePropertiesVisitor(Session s) {
        super(s);
    }

    @Nullable
    private static PropertyDefinition resolvePropertyDefinition(@NotNull String propName, @NotNull Node parentNode) throws RepositoryException {
        NodeType primaryNodeType = parentNode.getPrimaryNodeType();
        PropertyDefinition propDef = NodePropertiesVisitor.resolvePropertyDefinition(propName, primaryNodeType);
        if (propDef == null) {
            NodeType mixinNodeType;
            NodeType[] mixinNodeTypes;
            NodeType[] nodeTypeArray = mixinNodeTypes = parentNode.getMixinNodeTypes();
            int n = nodeTypeArray.length;
            for (int i = 0; i < n && (propDef = NodePropertiesVisitor.resolvePropertyDefinition(propName, mixinNodeType = nodeTypeArray[i])) == null; ++i) {
            }
        }
        return propDef;
    }

    @Nullable
    private static PropertyDefinition resolvePropertyDefinition(@NotNull String propName, @NotNull NodeType nodeType) {
        return Stream.of(nodeType.getPropertyDefinitions()).filter(pd -> propName.equals(pd.getName())).findFirst().orElse(null);
    }

    protected static boolean isUnchangedAutocreatedProperty(Node n, String propertyPath) throws RepositoryException {
        Property property;
        String name;
        PropertyDefinition pd;
        if (n.hasProperty(propertyPath) && (pd = NodePropertiesVisitor.resolvePropertyDefinition(name = (property = n.getProperty(propertyPath)).getName(), property.getParent())) != null && pd.isAutoCreated()) {
            Object[] objectArray;
            Object[] objectArray2 = pd.getDefaultValues();
            if (property.isMultiple()) {
                objectArray = property.getValues();
            } else {
                Value[] valueArray = new Value[1];
                objectArray = valueArray;
                valueArray[0] = property.getValue();
            }
            return Arrays.equals(objectArray2, objectArray);
        }
        return false;
    }

    private static boolean needToSetProperty(@NotNull Node n, @NotNull PropertyLine line) throws RepositoryException {
        if (!line.isDefault()) {
            return true;
        }
        String name = line.getPropertyName();
        boolean needToSet = NodePropertiesVisitor.isUnchangedAutocreatedProperty(n, name) ? true : !n.hasProperty(name) || n.getProperty(name) == null;
        return needToSet;
    }

    private static boolean needToSetProperty(Session session, Authorizable a, String pRelPath, PropertyLine line) throws RepositoryException {
        if (!line.isDefault()) {
            return true;
        }
        Node n = null;
        if (session.nodeExists(a.getPath())) {
            n = session.getNode(a.getPath());
        }
        boolean needToSet = n != null && NodePropertiesVisitor.isUnchangedAutocreatedProperty(n, pRelPath) ? true : !a.hasProperty(pRelPath) || a.getProperty(pRelPath) == null;
        return needToSet;
    }

    private static String toRelPath(String subTreePath, String name) {
        String pRelPath;
        if (subTreePath == null || subTreePath.isEmpty()) {
            pRelPath = name;
        } else {
            if (subTreePath.startsWith("/")) {
                subTreePath = subTreePath.substring(1);
            }
            pRelPath = String.format("%s/%s", subTreePath, name);
        }
        return pRelPath;
    }

    @NotNull
    private static Iterable<Authorizable> getAuthorizables(@NotNull Session session, @NotNull String ids) throws RepositoryException {
        ArrayList<Authorizable> authorizables = new ArrayList<Authorizable>();
        for (String id : Text.explode((String)ids, (int)44)) {
            Authorizable a = UserUtil.getAuthorizable(session, id);
            if (a == null) {
                throw new PathNotFoundException("Cannot resolve path of authorizable with id '" + id + "'.");
            }
            authorizables.add(a);
        }
        return authorizables;
    }

    private void setAuthorizableProperties(String nodePath, List<PropertyLine> propertyLines) throws RepositoryException {
        int lastHashIndex = nodePath.lastIndexOf(35);
        if (lastHashIndex == -1) {
            throw new IllegalStateException("Invalid format of authorizable path: # deliminator expected.");
        }
        String ids = nodePath.substring(PATH_AUTHORIZABLE.length(), lastHashIndex);
        String subTreePath = nodePath.substring(lastHashIndex + 1);
        for (Authorizable a : NodePropertiesVisitor.getAuthorizables(this.session, ids)) {
            this.log.info("Setting properties on authorizable '{}'", (Object)a.getID());
            for (PropertyLine pl : propertyLines) {
                String pName = pl.getPropertyName();
                String pRelPath = NodePropertiesVisitor.toRelPath(subTreePath, pName);
                if (NodePropertiesVisitor.needToSetProperty(this.session, a, pRelPath, pl)) {
                    List values = pl.getPropertyValues();
                    if (values.size() > 1) {
                        Value[] pValues = this.convertToValues(values);
                        a.setProperty(pRelPath, pValues);
                        continue;
                    }
                    Value pValue = this.convertToValue(values.get(0));
                    a.setProperty(pRelPath, pValue);
                    continue;
                }
                this.log.info("Property '{}' already set on authorizable '{}', existing value will not be overwritten in 'default' mode", (Object)pRelPath, (Object)a.getID());
            }
        }
    }

    private void setNodeProperties(String nodePath, List<PropertyLine> propertyLines) throws RepositoryException {
        this.log.info("Setting properties on nodePath '{}'", (Object)nodePath);
        Node n = this.session.getNode(nodePath);
        for (PropertyLine pl : propertyLines) {
            String pName = pl.getPropertyName();
            if (NodePropertiesVisitor.needToSetProperty(n, pl)) {
                int newType = PropertyType.valueFromName((String)pl.getPropertyType().name());
                Value[] newValues = this.convertToValues(pl.getPropertyValues());
                Property oldProperty = n.hasProperty(pName) ? n.getProperty(pName) : null;
                if (!this.hasPropertyChange(oldProperty, newType, newValues)) continue;
                if (newValues.length == 1 && !pl.isMultiple()) {
                    n.setProperty(pName, newValues[0], newType);
                    continue;
                }
                n.setProperty(pName, newValues, newType);
                continue;
            }
            this.log.info("Property '{}' already set on path '{}', existing value will not be overwritten in 'default' mode", (Object)pName, (Object)nodePath);
        }
    }

    private boolean hasPropertyChange(Property oldProperty, int newType, Value ... newValues) throws RepositoryException {
        Value[] valueArray;
        if (oldProperty == null || oldProperty.getType() != newType) {
            return true;
        }
        if (oldProperty.isMultiple()) {
            valueArray = oldProperty.getValues();
        } else {
            Value[] valueArray2 = new Value[1];
            valueArray = valueArray2;
            valueArray2[0] = oldProperty.getValue();
        }
        Value[] oldValues = valueArray;
        if (oldValues.length != newValues.length) {
            return true;
        }
        for (int i = 0; i < oldValues.length; ++i) {
            Value oldValue = oldValues[i];
            Value newValue = newValues[i];
            if (NodePropertiesVisitor.valueEquals(oldValue, newValue)) continue;
            return true;
        }
        return false;
    }

    private static boolean valueEquals(Value oldValue, Value newValue) throws RepositoryException {
        return oldValue.getType() == newValue.getType() && oldValue.getString().equals(newValue.getString());
    }

    @Override
    public void visitSetProperties(SetProperties sp) {
        for (String nodePath : sp.getPaths()) {
            try {
                if (nodePath.startsWith(PATH_AUTHORIZABLE)) {
                    this.setAuthorizableProperties(nodePath, sp.getPropertyLines());
                    continue;
                }
                this.setNodeProperties(nodePath, sp.getPropertyLines());
            }
            catch (RepositoryException e) {
                this.report((Exception)((Object)e), "Unable to set properties on path [" + nodePath + "]:" + (Object)((Object)e));
            }
        }
    }

    private Value[] convertToValues(List<Object> values) {
        int size = values.size();
        Value[] valueArray = new Value[size];
        for (int i = 0; i < size; ++i) {
            valueArray[i] = this.convertToValue(values.get(i));
        }
        return valueArray;
    }

    private Value convertToValue(Object value) {
        StringValue convertedValue = null;
        if (value instanceof String) {
            convertedValue = new StringValue((String)value);
        } else if (value instanceof Double) {
            convertedValue = new DoubleValue((Double)value);
        } else if (value instanceof Long) {
            convertedValue = new LongValue((Long)value);
        } else if (value instanceof Boolean) {
            convertedValue = new BooleanValue((Boolean)value);
        } else if (value instanceof Calendar) {
            convertedValue = new DateValue((Calendar)value);
        } else {
            this.report("Unable to convert " + value + " to jcr Value");
        }
        return convertedValue;
    }
}

