/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.injectors;

import jakarta.servlet.http.HttpServletRequest;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.wrappers.JakartaToJavaxRequestWrapper;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.impl.injectors.SelfInjector;
import org.apache.sling.models.impl.model.ConstructorParameter;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.injectorspecific.StaticInjectAnnotationProcessorFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class SelfInjectorTest {
    private SelfInjector injector = new SelfInjector();
    @Mock
    private SlingJakartaHttpServletRequest request;
    @Mock
    private AnnotatedElement annotatedElement;
    @Mock
    private Model modelAnnotation;
    @Mock
    private DisposalCallbackRegistry registry;
    private ConstructorParameter firstConstructorParameter;
    private ConstructorParameter secondConstructorParameter;

    SelfInjectorTest() {
    }

    @BeforeEach
    void setup() {
        Mockito.lenient().when((Object)this.modelAnnotation.defaultInjectionStrategy()).thenReturn((Object)DefaultInjectionStrategy.REQUIRED);
        this.firstConstructorParameter = new ConstructorParameter(new Annotation[0], Object.class, Object.class, true, 0, null, new StaticInjectAnnotationProcessorFactory[0], null);
        this.secondConstructorParameter = new ConstructorParameter(new Annotation[0], Object.class, Object.class, true, 1, null, new StaticInjectAnnotationProcessorFactory[0], null);
    }

    @Test
    void testJakartaMatchingClass() {
        Assertions.assertSame((Object)this.request, (Object)this.injector.getValue((Object)this.request, "notRelevant", SlingJakartaHttpServletRequest.class, this.firstConstructorParameter.getAnnotatedElement(), this.registry));
        Assertions.assertNull((Object)this.injector.getValue((Object)this.request, "notRelevant", SlingJakartaHttpServletRequest.class, this.secondConstructorParameter.getAnnotatedElement(), this.registry));
        Assertions.assertNull((Object)this.injector.getValue((Object)this.request, "notRelevant", SlingJakartaHttpServletRequest.class, this.annotatedElement, this.registry));
    }

    @Deprecated
    @Test
    void testJavaxMatchingClass() {
        SlingHttpServletRequest javaxRequest = JakartaToJavaxRequestWrapper.toJavaxRequest((SlingJakartaHttpServletRequest)this.request);
        Assertions.assertSame((Object)javaxRequest, (Object)this.injector.getValue((Object)javaxRequest, "notRelevant", SlingHttpServletRequest.class, this.firstConstructorParameter.getAnnotatedElement(), this.registry));
        Assertions.assertNull((Object)this.injector.getValue((Object)javaxRequest, "notRelevant", SlingHttpServletRequest.class, this.secondConstructorParameter.getAnnotatedElement(), this.registry));
        Assertions.assertNull((Object)this.injector.getValue((Object)javaxRequest, "notRelevant", SlingHttpServletRequest.class, this.annotatedElement, this.registry));
    }

    @Test
    void testJakartaMatchingSubClass() {
        Assertions.assertSame((Object)this.request, (Object)this.injector.getValue((Object)this.request, "notRelevant", HttpServletRequest.class, this.firstConstructorParameter.getAnnotatedElement(), this.registry));
        Assertions.assertNull((Object)this.injector.getValue((Object)this.request, "notRelevant", HttpServletRequest.class, this.secondConstructorParameter.getAnnotatedElement(), this.registry));
        Assertions.assertNull((Object)this.injector.getValue((Object)this.request, "notRelevant", HttpServletRequest.class, this.annotatedElement, this.registry));
    }

    @Deprecated
    @Test
    void testJavaxMatchingSubClass() {
        SlingHttpServletRequest javaxRequest = JakartaToJavaxRequestWrapper.toJavaxRequest((SlingJakartaHttpServletRequest)this.request);
        Assertions.assertSame((Object)javaxRequest, (Object)this.injector.getValue((Object)javaxRequest, "notRelevant", javax.servlet.http.HttpServletRequest.class, this.firstConstructorParameter.getAnnotatedElement(), this.registry));
        Assertions.assertNull((Object)this.injector.getValue((Object)javaxRequest, "notRelevant", javax.servlet.http.HttpServletRequest.class, this.secondConstructorParameter.getAnnotatedElement(), this.registry));
        Assertions.assertNull((Object)this.injector.getValue((Object)javaxRequest, "notRelevant", javax.servlet.http.HttpServletRequest.class, this.annotatedElement, this.registry));
    }

    @Test
    void testNotMatchingClass() {
        Assertions.assertNull((Object)this.injector.getValue((Object)this.request, "notRelevant", ResourceResolver.class, this.firstConstructorParameter.getAnnotatedElement(), this.registry));
        Assertions.assertNull((Object)this.injector.getValue((Object)this.request, "notRelevant", ResourceResolver.class, this.secondConstructorParameter.getAnnotatedElement(), this.registry));
        Assertions.assertNull((Object)this.injector.getValue((Object)this.request, "notRelevant", ResourceResolver.class, this.annotatedElement, this.registry));
    }

    @Test
    void testJakartaWithNullName() {
        Assertions.assertSame((Object)this.request, (Object)this.injector.getValue((Object)this.request, null, SlingJakartaHttpServletRequest.class, this.firstConstructorParameter.getAnnotatedElement(), this.registry));
        Assertions.assertNull((Object)this.injector.getValue((Object)this.request, null, SlingJakartaHttpServletRequest.class, this.secondConstructorParameter.getAnnotatedElement(), this.registry));
        Assertions.assertNull((Object)this.injector.getValue((Object)this.request, null, SlingJakartaHttpServletRequest.class, this.annotatedElement, this.registry));
    }

    @Deprecated
    @Test
    void testJavaxWithNullName() {
        SlingHttpServletRequest javaxRequest = JakartaToJavaxRequestWrapper.toJavaxRequest((SlingJakartaHttpServletRequest)this.request);
        Assertions.assertSame((Object)javaxRequest, (Object)this.injector.getValue((Object)javaxRequest, null, SlingHttpServletRequest.class, this.firstConstructorParameter.getAnnotatedElement(), this.registry));
        Assertions.assertNull((Object)this.injector.getValue((Object)javaxRequest, null, SlingHttpServletRequest.class, this.secondConstructorParameter.getAnnotatedElement(), this.registry));
        Assertions.assertNull((Object)this.injector.getValue((Object)javaxRequest, null, SlingHttpServletRequest.class, this.annotatedElement, this.registry));
    }

    @Test
    void testJakartaMatchingClassWithSelfAnnotation() {
        Mockito.when((Object)this.annotatedElement.isAnnotationPresent(Self.class)).thenReturn((Object)true);
        Object result = this.injector.getValue((Object)this.request, "notRelevant", SlingJakartaHttpServletRequest.class, this.annotatedElement, this.registry);
        Assertions.assertSame((Object)this.request, (Object)result);
    }

    @Deprecated
    @Test
    void testJavaxMatchingClassWithSelfAnnotation() {
        SlingHttpServletRequest javaxRequest = JakartaToJavaxRequestWrapper.toJavaxRequest((SlingJakartaHttpServletRequest)this.request);
        Mockito.when((Object)this.annotatedElement.isAnnotationPresent(Self.class)).thenReturn((Object)true);
        Object result = this.injector.getValue((Object)javaxRequest, "notRelevant", SlingHttpServletRequest.class, this.annotatedElement, this.registry);
        Assertions.assertSame((Object)javaxRequest, (Object)result);
    }

    @Test
    void testNotMatchingClassWithSelfAnnotation() {
        Mockito.when((Object)this.annotatedElement.isAnnotationPresent(Self.class)).thenReturn((Object)true);
        Object result = this.injector.getValue((Object)this.request, "notRelevant", ResourceResolver.class, this.annotatedElement, this.registry);
        Assertions.assertSame((Object)this.request, (Object)result);
    }
}

