/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.util;

import java.net.URI;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.exceptions.TestingValidationException;

public class HttpUtils {
    public static void verifyHttpStatus(SlingHttpResponse response, int ... expectedStatus) throws TestingValidationException {
        if (!HttpUtils.checkStatus((HttpResponse)response, expectedStatus)) {
            HttpUtils.throwError((HttpResponse)response, HttpUtils.buildDefaultErrorMessage(response), expectedStatus);
        }
    }

    public static void verifyHttpStatus(HttpResponse response, String errorMessage, int ... expectedStatus) throws TestingValidationException {
        if (!HttpUtils.checkStatus(response, expectedStatus)) {
            HttpUtils.throwError(response, errorMessage, expectedStatus);
        }
    }

    private static boolean checkStatus(HttpResponse response, int ... expectedStatus) {
        if (response == null) {
            throw new NullPointerException("The response is null!");
        }
        if (expectedStatus == null || expectedStatus.length == 0) {
            throw new IllegalArgumentException("At least one expected HTTP Status must be set!");
        }
        int givenStatus = HttpUtils.getHttpStatus(response);
        for (int expected : expectedStatus) {
            if (givenStatus != expected) continue;
            return true;
        }
        return false;
    }

    private static boolean throwError(HttpResponse response, String errorMessage, int ... expectedStatus) throws TestingValidationException {
        String errorMsg = "Expected HTTP Status: ";
        for (int expected : expectedStatus) {
            errorMsg = errorMsg + expected + " ";
        }
        int givenStatus = HttpUtils.getHttpStatus(response);
        errorMsg = errorMsg + ". Instead " + givenStatus + " was returned!\n";
        if (errorMessage != null) {
            errorMsg = errorMsg + errorMessage;
        }
        throw new TestingValidationException(errorMsg, givenStatus);
    }

    public static String buildDefaultErrorMessage(SlingHttpResponse resp) {
        String content = resp.getContent();
        if (content == null) {
            return "";
        }
        String errorMsg = resp.getSlingMessage();
        errorMsg = errorMsg == null || errorMsg.length() == 0 ? " Response Content:\n" + content : "Error Message: \n" + errorMsg;
        return errorMsg;
    }

    public static int getHttpStatus(HttpResponse response) {
        return response.getStatusLine().getStatusCode();
    }

    public static String getLocationHeader(HttpResponse response) throws TestingValidationException {
        if (response == null) {
            throw new TestingValidationException("Response must not be null!");
        }
        String locationPath = null;
        Header locationHeader = response.getFirstHeader("Location");
        if (locationHeader != null) {
            String location = locationHeader.getValue();
            URI locationURI = URI.create(location);
            locationPath = locationURI.getPath();
        }
        if (locationPath == null) {
            throw new TestingValidationException("not able to determine location path");
        }
        return locationPath;
    }

    public static boolean isInHttpStatusRange(HttpResponse response, int range) {
        return range == response.getStatusLine().getStatusCode() / 100 * 100;
    }

    public static int[] getExpectedStatus(int defaultStatus, int ... expectedStatus) {
        if (expectedStatus == null || expectedStatus.length == 0) {
            expectedStatus = new int[]{defaultStatus};
        }
        return expectedStatus;
    }
}

