/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.validation.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.i18n.ResourceBundleProvider;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.apache.sling.validation.SlingValidationException;
import org.apache.sling.validation.ValidationResult;
import org.apache.sling.validation.ValidationService;
import org.apache.sling.validation.impl.CompositeValidationResult;
import org.apache.sling.validation.impl.ResourceToValidationResultAdapterFactory;
import org.apache.sling.validation.impl.ValidationResourceVisitor;
import org.apache.sling.validation.impl.ValidationServiceConfiguration;
import org.apache.sling.validation.impl.ValidatorContextImpl;
import org.apache.sling.validation.impl.ValidatorMap;
import org.apache.sling.validation.model.ChildResource;
import org.apache.sling.validation.model.ResourceProperty;
import org.apache.sling.validation.model.ValidationModel;
import org.apache.sling.validation.model.ValidatorInvocation;
import org.apache.sling.validation.model.spi.ValidationModelRetriever;
import org.apache.sling.validation.spi.Validator;
import org.apache.sling.validation.spi.ValidatorContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Designate(ocd=ValidationServiceConfiguration.class)
public class ValidationServiceImpl
implements ValidationService {
    @Nonnull
    protected static final String I18N_KEY_WRONG_PROPERTY_TYPE = "sling.validator.wrong-property-type";
    @Nonnull
    protected static final String I18N_KEY_EXPECTED_MULTIVALUE_PROPERTY = "sling.validator.multi-value-property-required";
    @Nonnull
    protected static final String I18N_KEY_MISSING_REQUIRED_PROPERTY_WITH_NAME = "sling.validator.missing-required-property-with-name";
    @Nonnull
    protected static final String I18N_KEY_MISSING_REQUIRED_PROPERTY_MATCHING_PATTERN = "sling.validator.missing-required-property-matching-pattern";
    @Nonnull
    protected static final String I18N_KEY_MISSING_REQUIRED_CHILD_RESOURCE_WITH_NAME = "sling.validator.missing-required-child-resource-with-name";
    @Nonnull
    protected static final String I18N_KEY_MISSING_REQUIRED_CHILD_RESOURCE_MATCHING_PATTERN = "sling.validator.missing-required-child-resource-matching-pattern";
    private static final Logger LOG = LoggerFactory.getLogger(ValidationServiceImpl.class);
    @Reference
    ValidationModelRetriever modelRetriever;
    @Nonnull
    final ValidatorMap validatorMap = new ValidatorMap();
    Collection<String> searchPaths;
    ValidationServiceConfiguration configuration;
    @Reference
    private ResourceResolverFactory rrf = null;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.AT_LEAST_ONE, policyOption=ReferencePolicyOption.GREEDY)
    volatile List<ResourceBundleProvider> resourceBundleProviders;
    @Reference
    private ServiceUserMapped serviceUserMapped;

    @Activate
    protected void activate(ValidationServiceConfiguration configuration) {
        this.configuration = configuration;
        try (ResourceResolver rr = null;){
            rr = this.rrf.getServiceResourceResolver(null);
            this.searchPaths = Arrays.asList(rr.getSearchPath());
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY, policy=ReferencePolicy.DYNAMIC)
    protected void addValidator(@Nonnull Validator<?> validator, Map<String, Object> properties, ServiceReference<Validator<?>> serviceReference) {
        this.validatorMap.put(properties, validator, serviceReference);
    }

    protected void removeValidator(@Nonnull Validator<?> validator, Map<String, Object> properties, ServiceReference<Validator<?>> serviceReference) {
        this.validatorMap.remove(properties, validator, serviceReference);
    }

    protected void updatedValidator(@Nonnull Validator<?> validator, Map<String, Object> properties, ServiceReference<Validator<?>> serviceReference) {
        this.validatorMap.update(properties, validator, serviceReference);
    }

    @CheckForNull
    public ValidationModel getValidationModel(@Nonnull String validatedResourceType, String resourcePath, boolean considerResourceSuperTypeModels) {
        if (validatedResourceType == null) {
            throw new IllegalArgumentException("ValidationService.getValidationModel - cannot accept null as resource type. Resource path was: " + resourcePath);
        }
        validatedResourceType = this.getRelativeResourceType(validatedResourceType);
        return this.modelRetriever.getValidationModel(validatedResourceType, resourcePath, considerResourceSuperTypeModels);
    }

    @Nonnull
    protected String getRelativeResourceType(@Nonnull String resourceType) throws IllegalArgumentException {
        if (resourceType.startsWith("/")) {
            LOG.debug("try to strip the search path from the resource type");
            for (String searchPath : this.searchPaths) {
                if (!resourceType.startsWith(searchPath)) continue;
                resourceType = resourceType.substring(searchPath.length());
                return resourceType;
            }
            throw new IllegalArgumentException("Can only deal with resource types inside the resource resolver's search path (" + StringUtils.join((Object[])this.searchPaths.toArray()) + ") but given resource type " + resourceType + " is outside!");
        }
        return resourceType;
    }

    @CheckForNull
    public ValidationModel getValidationModel(@Nonnull Resource resource, boolean considerResourceSuperTypeModels) {
        return this.getValidationModel(resource.getResourceType(), resource.getPath(), considerResourceSuperTypeModels);
    }

    @Nonnull
    public ValidationResult validate(@Nonnull Resource resource, @Nonnull ValidationModel model) {
        return this.validate(resource, model, "");
    }

    @Nonnull
    private ResourceBundle getDefaultResourceBundle() {
        Locale locale = Locale.ENGLISH;
        for (int i = this.resourceBundleProviders.size() - 1; i >= 0; --i) {
            ResourceBundleProvider resourceBundleProvider = this.resourceBundleProviders.get(i);
            ResourceBundle defaultResourceBundle = resourceBundleProvider.getResourceBundle(locale);
            if (defaultResourceBundle == null) continue;
            return defaultResourceBundle;
        }
        throw new IllegalStateException("There is no resource provider in the system, providing a resource bundle for locale");
    }

    private int getSeverityForValidator(Integer severityFromModel, Integer severityFromValidator) {
        if (severityFromModel != null) {
            return severityFromModel;
        }
        if (severityFromValidator != null) {
            return severityFromValidator;
        }
        return this.configuration.defaultSeverity();
    }

    @Nonnull
    protected ValidationResult validate(@Nonnull Resource resource, @Nonnull ValidationModel model, @Nonnull String relativePath) {
        if (resource == null || model == null || relativePath == null) {
            throw new IllegalArgumentException("ValidationService.validate - cannot accept null parameters");
        }
        ResourceBundle defaultResourceBundle = this.getDefaultResourceBundle();
        CompositeValidationResult result = new CompositeValidationResult();
        ValueMap valueMap = (ValueMap)resource.adaptTo(ValueMap.class);
        if (valueMap == null) {
            valueMap = new ValueMapDecorator(Collections.emptyMap());
        }
        this.validateValueMap(valueMap, resource, relativePath, model.getResourceProperties(), result, defaultResourceBundle);
        this.validateChildren(resource, relativePath, model.getChildren(), result, defaultResourceBundle);
        if (this.configuration.cacheValidationResultsOnResources()) {
            ResourceToValidationResultAdapterFactory.putValidationResultToCache(result, resource);
        }
        return result;
    }

    private void validateChildren(@Nonnull Resource resource, @Nonnull String relativePath, @Nonnull Collection<ChildResource> childResources, @Nonnull CompositeValidationResult result, @Nonnull ResourceBundle defaultResourceBundle) {
        for (ChildResource childResource : childResources) {
            Pattern pattern = childResource.getNamePattern();
            if (pattern != null) {
                boolean foundMatch = false;
                for (Resource child : resource.getChildren()) {
                    Matcher matcher = pattern.matcher(child.getName());
                    if (!matcher.matches()) continue;
                    this.validateChildResource(child, relativePath, childResource, result, defaultResourceBundle);
                    foundMatch = true;
                }
                if (foundMatch || !childResource.isRequired()) continue;
                result.addFailure(relativePath, this.configuration.defaultSeverity(), defaultResourceBundle, I18N_KEY_MISSING_REQUIRED_CHILD_RESOURCE_MATCHING_PATTERN, pattern.toString());
                continue;
            }
            Resource expectedResource = resource.getChild(childResource.getName());
            if (expectedResource != null) {
                this.validateChildResource(expectedResource, relativePath, childResource, result, defaultResourceBundle);
                continue;
            }
            if (!childResource.isRequired()) continue;
            result.addFailure(relativePath, this.configuration.defaultSeverity(), defaultResourceBundle, I18N_KEY_MISSING_REQUIRED_CHILD_RESOURCE_WITH_NAME, childResource.getName());
        }
    }

    private void validateChildResource(@Nonnull Resource resource, @Nonnull String relativePathOfParent, @Nonnull ChildResource childResource, @Nonnull CompositeValidationResult result, @Nonnull ResourceBundle defaultResourceBundle) {
        String relativePath = relativePathOfParent.isEmpty() ? resource.getName() : relativePathOfParent + "/" + resource.getName();
        this.validateValueMap((ValueMap)resource.adaptTo(ValueMap.class), resource, relativePath, childResource.getProperties(), result, defaultResourceBundle);
        this.validateChildren(resource, relativePath, childResource.getChildren(), result, defaultResourceBundle);
    }

    @Nonnull
    public ValidationResult validate(@Nonnull ValueMap valueMap, @Nonnull ValidationModel model) {
        if (valueMap == null || model == null) {
            throw new IllegalArgumentException("ValidationResult.validate - cannot accept null parameters");
        }
        ResourceBundle defaultResourceBundle = this.getDefaultResourceBundle();
        CompositeValidationResult result = new CompositeValidationResult();
        this.validateValueMap(valueMap, null, "", model.getResourceProperties(), result, defaultResourceBundle);
        return result;
    }

    @Nonnull
    public ValidationResult validateResourceRecursively(@Nonnull Resource resource, boolean enforceValidation, Predicate<Resource> filter, boolean considerResourceSuperTypeModels) throws IllegalStateException, IllegalArgumentException, SlingValidationException {
        ValidationResourceVisitor visitor = new ValidationResourceVisitor(this, resource.getPath(), enforceValidation, filter, considerResourceSuperTypeModels);
        visitor.accept(resource);
        return visitor.getResult();
    }

    private void validateValueMap(ValueMap valueMap, Resource resource, @Nonnull String relativePath, @Nonnull Collection<ResourceProperty> resourceProperties, @Nonnull CompositeValidationResult result, @Nonnull ResourceBundle defaultResourceBundle) {
        if (valueMap == null) {
            throw new IllegalArgumentException("ValueMap may not be null");
        }
        for (ResourceProperty resourceProperty : resourceProperties) {
            Pattern pattern = resourceProperty.getNamePattern();
            if (pattern != null) {
                boolean foundMatch = false;
                for (String key : valueMap.keySet()) {
                    if (!pattern.matcher(key).matches()) continue;
                    foundMatch = true;
                    this.validatePropertyValue(key, valueMap, resource, relativePath, resourceProperty, result, defaultResourceBundle);
                }
                if (foundMatch || !resourceProperty.isRequired()) continue;
                result.addFailure(relativePath, this.configuration.defaultSeverity(), defaultResourceBundle, I18N_KEY_MISSING_REQUIRED_PROPERTY_MATCHING_PATTERN, pattern.toString());
                continue;
            }
            this.validatePropertyValue(resourceProperty.getName(), valueMap, resource, relativePath, resourceProperty, result, defaultResourceBundle);
        }
    }

    private void validatePropertyValue(@Nonnull String property, ValueMap valueMap, Resource resource, @Nonnull String relativePath, @Nonnull ResourceProperty resourceProperty, @Nonnull CompositeValidationResult result, @Nonnull ResourceBundle defaultResourceBundle) {
        Object fieldValues = valueMap.get((Object)property);
        if (fieldValues == null) {
            if (resourceProperty.isRequired()) {
                result.addFailure(relativePath, this.configuration.defaultSeverity(), defaultResourceBundle, I18N_KEY_MISSING_REQUIRED_PROPERTY_WITH_NAME, property);
            }
            return;
        }
        List validatorInvocations = resourceProperty.getValidatorInvocations();
        if (resourceProperty.isMultiple() && !fieldValues.getClass().isArray()) {
            result.addFailure(relativePath + property, this.configuration.defaultSeverity(), defaultResourceBundle, I18N_KEY_EXPECTED_MULTIVALUE_PROPERTY, new Object[0]);
            return;
        }
        for (ValidatorInvocation validatorInvocation : validatorInvocations) {
            Object[] typedValue;
            ValidatorMap.ValidatorMetadata validatorMetadata = this.validatorMap.get(validatorInvocation.getValidatorId());
            if (validatorMetadata == null) {
                throw new IllegalStateException("Could not find validator with id '" + validatorInvocation.getValidatorId() + "'");
            }
            int severity = this.getSeverityForValidator(validatorInvocation.getSeverity(), validatorMetadata.getSeverity());
            Class<?> type = validatorMetadata.getType();
            if (!type.isArray()) {
                try {
                    type = Class.forName("[L" + type.getName() + ";", false, type.getClassLoader());
                }
                catch (ClassNotFoundException e) {
                    throw new SlingValidationException("Could not generate array class for type " + type, (Throwable)e);
                }
            }
            if ((typedValue = (Object[])valueMap.get(property, type)) == null || typedValue.length > 0 && typedValue[0] == null) {
                result.addFailure(relativePath + property, severity, defaultResourceBundle, I18N_KEY_WRONG_PROPERTY_TYPE, validatorMetadata.getType());
                return;
            }
            if (validatorMetadata.getType().isArray()) {
                this.validateValue(result, typedValue, property, relativePath, valueMap, resource, validatorMetadata.getValidator(), validatorInvocation.getParameters(), defaultResourceBundle, severity);
                continue;
            }
            Object[] array = typedValue;
            if (array.length == 1) {
                this.validateValue(result, array[0], property, relativePath, valueMap, resource, validatorMetadata.getValidator(), validatorInvocation.getParameters(), defaultResourceBundle, severity);
                continue;
            }
            int n = 0;
            for (Object item : array) {
                this.validateValue(result, item, property + "[" + n++ + "]", relativePath, valueMap, resource, validatorMetadata.getValidator(), validatorInvocation.getParameters(), defaultResourceBundle, severity);
            }
        }
    }

    private void validateValue(CompositeValidationResult result, @Nonnull Object value, String property, String relativePath, @Nonnull ValueMap valueMap, Resource resource, @Nonnull Validator validator, ValueMap validatorParameters, @Nonnull ResourceBundle defaultResourceBundle, int severity) {
        try {
            ValidatorContextImpl validationContext = new ValidatorContextImpl(relativePath + property, severity, valueMap, resource, defaultResourceBundle);
            ValidationResult validatorResult = validator.validate(value, (ValidatorContext)validationContext, validatorParameters);
            result.addValidationResult(validatorResult);
        }
        catch (SlingValidationException e) {
            throw new SlingValidationException("Could not call validator " + validator.getClass().getName() + " for resourceProperty " + relativePath + property, (Throwable)e);
        }
    }
}

