/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.vfs;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.base.AbstractTransportSender;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.axis2.transport.base.ManagementSupport;
import org.apache.axis2.util.MessageProcessorSelector;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.apache.synapse.transport.vfs.VFSOutTransportInfo;
import org.apache.synapse.transport.vfs.VFSUtils;

public class VFSTransportSender
extends AbstractTransportSender
implements ManagementSupport {
    private FileSystemManager fsManager = null;
    private boolean globalFileLockingFlag = true;

    public VFSTransportSender() {
        this.log = LogFactory.getLog(VFSTransportSender.class);
    }

    public void init(ConfigurationContext cfgCtx, TransportOutDescription transportOut) throws AxisFault {
        super.init(cfgCtx, transportOut);
        try {
            String strLockingFlag;
            StandardFileSystemManager fsm = new StandardFileSystemManager();
            fsm.setConfiguration(((Object)((Object)this)).getClass().getClassLoader().getResource("providers.xml"));
            fsm.init();
            this.fsManager = fsm;
            Parameter lckFlagParam = transportOut.getParameter("transport.vfs.Locking");
            if (lckFlagParam != null && "disable".equals(strLockingFlag = lckFlagParam.getValue().toString())) {
                this.globalFileLockingFlag = false;
            }
        }
        catch (FileSystemException e) {
            this.handleException("Error initializing the file transport : " + e.getMessage(), (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendMessage(MessageContext msgCtx, String targetAddress, OutTransportInfo outTransportInfo) throws AxisFault {
        if (this.waitForSynchronousResponse(msgCtx)) {
            throw new AxisFault("The VFS transport doesn't support synchronous responses. Please use the appropriate (out only) message exchange pattern.");
        }
        VFSOutTransportInfo vfsOutInfo = null;
        if (targetAddress != null) {
            vfsOutInfo = new VFSOutTransportInfo(targetAddress, this.globalFileLockingFlag);
        } else if (outTransportInfo != null && outTransportInfo instanceof VFSOutTransportInfo) {
            vfsOutInfo = (VFSOutTransportInfo)outTransportInfo;
        }
        if (vfsOutInfo != null) {
            FileObject replyFile = null;
            try {
                boolean wasError = true;
                int retryCount = 0;
                int maxRetryCount = vfsOutInfo.getMaxRetryCount();
                long reconnectionTimeout = vfsOutInfo.getReconnectTimeout();
                boolean append = vfsOutInfo.isAppend();
                boolean isUseTempFile = vfsOutInfo.isUseTempFile();
                String actualTargetFileName = null;
                while (wasError) {
                    block39: {
                        try {
                            ++retryCount;
                            replyFile = this.fsManager.resolveFile(vfsOutInfo.getOutFileURI());
                            if (replyFile == null) {
                                this.log.error((Object)"replyFile is null");
                                throw new FileSystemException("replyFile is null");
                            }
                            wasError = false;
                        }
                        catch (FileSystemException e) {
                            this.log.error((Object)"cannot resolve replyFile", (Throwable)e);
                            if (maxRetryCount > retryCount) break block39;
                            this.handleException("cannot resolve replyFile repeatedly: " + e.getMessage(), (Exception)((Object)e));
                        }
                    }
                    if (!wasError) continue;
                    try {
                        Thread.sleep(reconnectionTimeout);
                    }
                    catch (InterruptedException e2) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (replyFile.exists()) {
                    if (replyFile.getType() == FileType.FOLDER) {
                        String tempTargetFileName;
                        if (isUseTempFile) {
                            tempTargetFileName = VFSUtils.generateTempFileName();
                            actualTargetFileName = VFSUtils.getFileName(msgCtx, vfsOutInfo);
                        } else {
                            tempTargetFileName = VFSUtils.getFileName(msgCtx, vfsOutInfo);
                        }
                        FileObject responseFile = this.fsManager.resolveFile(replyFile, tempTargetFileName);
                        if (vfsOutInfo.isFileLockingEnabled()) {
                            this.acquireLockForSending(responseFile, vfsOutInfo);
                            if (!responseFile.exists()) {
                                responseFile.createFile();
                            }
                            this.populateResponseFile(responseFile, msgCtx, append, true);
                            VFSUtils.releaseLock(this.fsManager, responseFile);
                        } else {
                            if (!responseFile.exists()) {
                                responseFile.createFile();
                            }
                            this.populateResponseFile(responseFile, msgCtx, append, false);
                        }
                        if (!isUseTempFile) return;
                        responseFile.moveTo(this.fsManager.resolveFile(replyFile, actualTargetFileName));
                        return;
                    }
                    if (replyFile.getType() == FileType.FILE) {
                        if (isUseTempFile) {
                            String tempTargetFileName = VFSUtils.generateTempFileName();
                            actualTargetFileName = replyFile.getURL().toString();
                            replyFile = this.getTempFileObject(this.fsManager, replyFile, tempTargetFileName);
                        }
                        if (vfsOutInfo.isFileLockingEnabled()) {
                            this.acquireLockForSending(replyFile, vfsOutInfo);
                            this.populateResponseFile(replyFile, msgCtx, append, true);
                            VFSUtils.releaseLock(this.fsManager, replyFile);
                        } else {
                            this.populateResponseFile(replyFile, msgCtx, append, false);
                        }
                        if (!isUseTempFile) return;
                        replyFile.moveTo(this.fsManager.resolveFile(actualTargetFileName));
                        return;
                    }
                    this.handleException("Unsupported reply file type : " + replyFile.getType() + " for file : " + vfsOutInfo.getOutFileURI());
                    return;
                }
                if (isUseTempFile) {
                    String tempTargetFileName = VFSUtils.generateTempFileName();
                    actualTargetFileName = replyFile.getURL().toString();
                    replyFile = this.getTempFileObject(this.fsManager, replyFile, tempTargetFileName);
                }
                if (vfsOutInfo.isFileLockingEnabled()) {
                    this.acquireLockForSending(replyFile, vfsOutInfo);
                    replyFile.createFile();
                    this.populateResponseFile(replyFile, msgCtx, append, true);
                    VFSUtils.releaseLock(this.fsManager, replyFile);
                } else {
                    replyFile.createFile();
                    this.populateResponseFile(replyFile, msgCtx, append, false);
                }
                if (!isUseTempFile) return;
                replyFile.moveTo(this.fsManager.resolveFile(actualTargetFileName));
                return;
            }
            catch (FileSystemException e) {
                this.handleException("Error resolving reply file : " + vfsOutInfo.getOutFileURI(), (Exception)((Object)e));
                return;
            }
            finally {
                if (replyFile != null) {
                    try {
                        if (this.fsManager != null && replyFile.getName() != null && replyFile.getName().getScheme() != null && replyFile.getName().getScheme().startsWith("file") && replyFile.getParent() != null && replyFile.getParent().getFileSystem() != null) {
                            this.fsManager.closeFileSystem(replyFile.getParent().getFileSystem());
                        }
                        replyFile.close();
                    }
                    catch (FileSystemException fileSystemException) {}
                }
            }
        }
        this.handleException("Unable to determine out transport information to send message");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateResponseFile(FileObject responseFile, MessageContext msgContext, boolean append, boolean lockingEnabled) throws AxisFault {
        MessageFormatter messageFormatter = MessageProcessorSelector.getMessageFormatter((MessageContext)msgContext);
        OMOutputFormat format = BaseUtils.getOMOutputFormat((MessageContext)msgContext);
        try {
            try (CountingOutputStream os = new CountingOutputStream(responseFile.getContent().getOutputStream(append));){
                messageFormatter.writeTo(msgContext, format, (OutputStream)os, false);
            }
            this.metrics.incrementMessagesSent(msgContext);
            this.metrics.incrementBytesSent(msgContext, os.getByteCount());
        }
        catch (FileSystemException e) {
            if (lockingEnabled) {
                VFSUtils.releaseLock(this.fsManager, responseFile);
            }
            this.metrics.incrementFaultsSending();
            this.handleException("IO Error while creating response file : " + VFSUtils.maskURLPassword(responseFile.getName().getURI()), (Exception)((Object)e));
        }
        catch (IOException e) {
            if (lockingEnabled) {
                VFSUtils.releaseLock(this.fsManager, responseFile);
            }
            this.metrics.incrementFaultsSending();
            this.handleException("IO Error while creating response file : " + VFSUtils.maskURLPassword(responseFile.getName().getURI()), e);
        }
    }

    private void acquireLockForSending(FileObject responseFile, VFSOutTransportInfo vfsOutInfo) throws AxisFault {
        int tryNum = 0;
        while (!VFSUtils.acquireLock(this.fsManager, responseFile)) {
            if (vfsOutInfo.getMaxRetryCount() == tryNum++) {
                this.handleException("Couldn't send the message to file : " + VFSUtils.maskURLPassword(responseFile.getName().getURI()) + ", unable to acquire the lock even after " + tryNum + " retries");
                continue;
            }
            this.log.warn((Object)("Couldn't get the lock for the file : " + VFSUtils.maskURLPassword(responseFile.getName().getURI()) + ", retry : " + tryNum + " scheduled after : " + vfsOutInfo.getReconnectTimeout()));
            try {
                Thread.sleep(vfsOutInfo.getReconnectTimeout());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private FileObject getTempFileObject(FileSystemManager fsManager, FileObject originalFileObj, String fileName) throws FileSystemException {
        return fsManager.resolveFile(originalFileObj.getParent(), fileName);
    }
}

